<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

Feb 11, 2019

Host: John Mertic

Rotating Secretary: Larry Gritz

Attendees:
  * Sean Cooper (_TSC_) - DNEG
  * Michael Dolan (_TSC_) - Sony Pictures Imageworks
  * Larry Gritz (_TSC_) - Sony Pictures Imageworks
  * Thanh Ha - Academy Software Foundation / Linux Foundation
  * Patrick Hodoul (_TSC_) - Autodesk
  * John Mertic - Academy Software Foundation / Linux Foundation
  * Carl Rand (_TSC_) - Foundry
  * Doug Walker (_TSC_) - Autodesk
  * Kevin Wheatley (_TSC_) - Framestore

# **OCIO TSC Meeting Notes**

* Election Results
    * Chair:  Michael Dolan, by offline vote over the last week.
    * Chief architect: Doug Walker, confirmed by unanimous voice vote.
* Infrastructure updates:
    * Domain transfer: LG reports he has identified the office at Sony Pictures that holds domains and working on the logistics of the transfer.
    * Repo transfer: Should be straightforward to transfer from GitHub imageworks to AcademySoftwareFoundation accounts. (Note: also must transfer ocio-config repo.)
    * Code scan:
        * Competed initial code scan to check for licenses, etc.
        * Overall pretty good
        * "ext/" directory containing upstream dependencies should perhaps be pulled in at build time rather than embedded? But there were reasons (convenience, lcms no longer maintained, patches for custom namespacing for us). We could download at build time and apply the patches, so still build just for us, but not have those packages' source embedded in our repo.
        * **TODO**: Patrick & Thanh to look offline at the initial CI builds and consider the ext packages to assess what can be pulled, what can be upstreamed, what must be embedded.
    * Communication tools:
        * If we want to move mail list communications to aswf.io, there is a migration path from google groups -> ASWF.io mail lists that will preserve the archives.
        * Nobody objected to moving to aswf.io, so JM to work on this.
        * JM can provision a dedicated Zoom line for meetings, if we want.
    * CLA system
        * New CLA system should be operational on Friday.
        * At that point, JM will send us links to get new CLAs signed.
        * **TODO**: JM to look into how to do retroactive DCOs. Investigate how necessary that is, considering we have CLAs from all prior contributors.

* Releases:
    * Do a patch against 1.1 that fixes a few minor things?
        * Consensus is that we should make 1.1.1 with some important non-breaking patches and release that fix right away.
        * **TODO**: Patrick will send Slack the list of candidate commits for a 1.1.1.
    * Do we make an intermediate release from master before v2.0? People want a "developer preview" to be able to use the new GPU path.
        * Patrick reluctant to make a full release.
        * Proposal: just make a "developer preview" tag in master to designate a point we think is stable and has some helpful new features, but we don't promise any support or compatibility with the eventual v2.
            * Down side: people will use it and expect us to support it.
            * No consensus that this is a good idea. Mark especially doesn't like unsupported dev preview tag.
            * But v2 will NOT be ready by SIGGRAPH 2019. In light of this, Mark thinks maybe we should have a real intermediate release.
            * Sean: Considering how long it takes us to review things and the long v2 schedule, maybe we should reconsider what is v2 and what gets pushed to v3? (Patrick points out: it's the same ADSK people supporting the release as building "v2", only so much bandwidth available, so an intermediate release will make the full release take even longer.
        * **Tabled** for further thought and discussion. Patrick made a GH issue for further discussion: #665

* Agenda for next time:
    * Talk about Python
