/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_BOOTOSFROMFSACCESS_H_
#define OPENDRIM_BOOTOSFROMFSACCESS_H_

#include "OS_Common.h"

#include "OpenDRIM_BootOSFromFS.h"
#include "assocOpenDRIM_BootOSFromFS.h"

int OS_OpenDRIM_BootOSFromFS_load(const CMPIBroker* broker, string& errorMessage);

int OS_OpenDRIM_BootOSFromFS_unload(string& errorMessage);

int OS_OpenDRIM_BootOSFromFS_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_BootOSFromFS>& instances, const char** properties, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_BootOSFromFS_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_BootOSFromFS& instance, const char** properties, string& errorMessage);

int OS_OpenDRIM_BootOSFromFS_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootOSFromFS& newInstance, const OpenDRIM_BootOSFromFS& oldInstance, const char** properties, string& errorMessage);

int OS_OpenDRIM_BootOSFromFS_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootOSFromFS& instance, string& errorMessage);

int OS_OpenDRIM_BootOSFromFS_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootOSFromFS& instance, string& errorMessage);

int OS_OpenDRIM_BootOSFromFS_associatorAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const char** properties, vector<Instance>& Dependent_associatedInstances, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_BootOSFromFS_associatorDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const char** properties, vector<Instance>& Antecedent_associatedInstances, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_BootOSFromFS_referenceAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const vector<Instance>& Dependent_instances, vector<OpenDRIM_BootOSFromFS>& OpenDRIM_BootOSFromFS_instances, const char** properties, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_BootOSFromFS_referenceDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const vector<Instance>& Antecedent_instances, vector<OpenDRIM_BootOSFromFS>& OpenDRIM_BootOSFromFS_instances, const char** properties, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_BootOSFromFS_populate(OpenDRIM_BootOSFromFS& instance, string& errorMessage);

#endif /*OPENDRIM_BOOTOSFROMFSACCESS_H_*/
