/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#include "OpenDRIM_GroupAccess.h"

int Simple_Identity_Management_OpenDRIM_Group_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_Group_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_Group_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_Group>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	// Read the /etc/group file
	string etc_group;
	
	CF_assert(CF_readTextFile("/etc/group", etc_group, errorMessage));
	
	vector<string> etc_group_lines;
	CF_splitText(etc_group_lines, etc_group, '\n');
	// In gi (getInstance) mode the first instance in the vector contains
	// the objectpath of the instance we're supposed to get
	string gi_name;
	if (discriminant=="gi")
		result[0].getName(gi_name);
	// For each line of /etc/group
	for (size_t i=0; i<etc_group_lines.size(); i++) {
		// Check the format of the line in /etc/group
		if (etc_group_lines[i]=="")
			break;
		vector<string> current_etc_group_line;
		CF_splitText(current_etc_group_line, etc_group_lines[i], ':');
		if (current_etc_group_line.size()!=4) {
			errorMessage="Wrong format (at line "+CF_intToStr((unsigned long) i+1)+"): /etc/group";
			return FAILED;
		}
		// Assign the values of the properties
		OpenDRIM_Group instance;
		instance.setName(current_etc_group_line[0]);
		instance.setCreationClassName("OpenDRIM_Group");
		instance.setElementName(current_etc_group_line[0]);
		instance.setGroupID(current_etc_group_line[2]);
		CF_splitText(instance.Members, current_etc_group_line[3], ',');
		// If we're in gi mode we check if we found the instance
		if (discriminant=="gi" && CF_strCmpNoCase(gi_name, current_etc_group_line[0])) {
			result[0]=instance;
			return OK;
			// We found the instance so we can exit here
		}
		// Add the instance to the vector
		if (discriminant=="ei" || discriminant=="ein")
			result.push_back(instance);
	}
	// If we get here it means we didn't find the instance
	if (discriminant=="gi")
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_Group_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_Group& instance, const char** properties, string& errorMessage) {
	_E_;
	string CreationClassName;
	instance.getCreationClassName(CreationClassName);
	
	if (!CF_strCmpNoCase(CreationClassName, "OpenDRIM_Group"))
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}
	
	vector<OpenDRIM_Group> instances;
	instances.push_back(instance);
	
	// Get the instance (it also checks if it exists)
	CF_assert(Simple_Identity_Management_OpenDRIM_Group_retrieve(broker, ctx, instances, properties, errorMessage, "gi"));
	
	instance=instances[0];
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_Group_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Group& newInstance, const OpenDRIM_Group& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Simple_Identity_Management_OpenDRIM_Group_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Group& instance, string& errorMessage) {
	_E_;
	string Name, GroupID, CreationClassName;
	instance.getCreationClassName(CreationClassName);
	if (!CF_strCmpNoCase(CreationClassName, "OpenDRIM_Group")) {
		errorMessage = "Wrong value: CreationClassName";
		return FAILED;
	}
	instance.getName(Name);
	instance.getGroupID(GroupID);
	string command="/usr/sbin/groupadd ";
	if (instance.getGroupID(GroupID)!=NOT_FOUND)
		command+="-g "+GroupID+" ";
	string stdOut, stdErr;
	
	// Invoke groupadd to create a new group
	CF_assert(CF_runCommand(command+Name, stdOut, stdErr, errorMessage));
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_Group_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Group& instance, string& errorMessage) {
	_E_;
	string Name;
	instance.getName(Name);
	string stdOut, stdErr;
	
	// Invoke groupdel to delete a group
	// Only groups which are not primary for any user can be deleted
	int errorCode=CF_runCommand("/usr/sbin/groupdel "+Name, stdOut, stdErr, errorMessage);
	if (errorCode!=OK) {
		if (stdErr.find("cannot remove user's primary group"))
			errorMessage="Primary groups cannot be deleted.";
		return errorCode;
	}
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_Group_populate(OpenDRIM_Group& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

