/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLFRAGMENT_KERNEL_SOURCE_H_
#define _GTLFRAGMENT_KERNEL_SOURCE_H_

#include <list>
#include <GTLFragment/Export.h>

namespace GTLCore {
  class CompilationMessages;
  class String;
}

namespace GTLFragment {
  class Metadata;
  /**
   * @ingroup GTLFragment
   * 
   * Define the source code of a Kernel. Allow to access to information like the metadata,
   * or the source code, or the parameters of the evaluateParam function.
   */
  class GTLFRAGMENT_EXPORT Source {
    protected:
      struct Private;
      Source(Private* nd);
    public:
      Source();
      Source(const Source& );
      Source& operator=(const Source& );
      ~Source();
      GTLCore::String name() const;
      GTLCore::String source() const;
      void setSource( const GTLCore::String& );
      void loadFromFile(const GTLCore::String& _fileName);
      /**
       * @return the metadata for this kernel.
       */
      const Metadata* metadata() const;
      GTLCore::CompilationMessages metadataCompilationMessages() const;
    private:
      inline void deref();
    protected:
      Private* d;
  };
}

#endif
