/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.DoublePipeline;
import java.util.stream.DoubleStream;
import java.util.stream.IntPipeline;
import java.util.stream.IntStream;
import java.util.stream.LongPipeline;
import java.util.stream.LongStream;
import java.util.stream.ReferencePipeline;
import java.util.stream.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamOpFlag;
import java.util.stream.Streams;
import jdk.internal.vm.annotation.IntrinsicCandidate;

public class Streams {
    public static final long MAX_ARRAY_SIZE = 0x7FFFFFF7L;
    private static final int MAX_ITERATOR_CHUNK_SIZE = 1024;
    public static final int STREAM_IS_DISTINCT = StreamOpFlag.IS_DISTINCT;
    public static final int STREAM_IS_SORTED = StreamOpFlag.IS_SORTED;
    public static final int STREAM_IS_ORDERED = StreamOpFlag.IS_ORDERED;
    public static final int STREAM_IS_SIZED = StreamOpFlag.IS_SIZED;
    private static final PrimitiveIterator<?> EMPTY_NUMERIC_ITERATOR = new /* Unavailable Anonymous Inner Class!! */;

    private Streams() {
        throw new Error("no instances");
    }

    public static <T> Stream<T> emptyStream() {
        return Streams.stream((Spliterator)Streams.emptySpliterator(), (int)0);
    }

    public static <T> Stream<T> stream(Supplier<? extends Spliterator<T>> supplier, int n) {
        Objects.requireNonNull(supplier);
        return new ReferencePipeline(supplier, n & ~StreamOpFlag.IS_PARALLEL);
    }

    public static <T> Stream<T> stream(Spliterator<T> spliterator, int n) {
        return Streams.stream(() -> spliterator, (int)n);
    }

    public static <T> Stream<T> parallelStream(Supplier<? extends Spliterator<T>> supplier, int n) {
        Objects.requireNonNull(supplier);
        return new ReferencePipeline(supplier, n | StreamOpFlag.IS_PARALLEL);
    }

    public static <T> Stream<T> parallelStream(Spliterator<T> spliterator, int n) {
        return Streams.parallelStream(() -> spliterator, (int)n);
    }

    public static IntStream emptyIntStream() {
        return Streams.intStream((Spliterator.OfPrimitive)Streams.emptyPrimitiveSpliterator(), (int)0);
    }

    public static IntStream intStream(Supplier<? extends Spliterator.OfPrimitive<Integer>> supplier, int n) {
        return new IntPipeline(supplier, n & ~StreamOpFlag.IS_PARALLEL);
    }

    public static IntStream intParallelStream(Supplier<? extends Spliterator.OfPrimitive<Integer>> supplier, int n) {
        return new IntPipeline(supplier, n | StreamOpFlag.IS_PARALLEL);
    }

    public static IntStream intStream(Spliterator.OfPrimitive<Integer> ofPrimitive, int n) {
        return new IntPipeline(() -> ofPrimitive, n & ~StreamOpFlag.IS_PARALLEL);
    }

    public static IntStream intParallelStream(Spliterator.OfPrimitive<Integer> ofPrimitive, int n) {
        return new IntPipeline(() -> ofPrimitive, n | StreamOpFlag.IS_PARALLEL);
    }

    public static LongStream emptyLongStream() {
        return Streams.longStream((Spliterator.OfPrimitive)Streams.emptyPrimitiveSpliterator(), (int)0);
    }

    public static LongStream longStream(Supplier<? extends Spliterator.OfPrimitive<Long>> supplier, int n) {
        return new LongPipeline(supplier, n & ~StreamOpFlag.IS_PARALLEL);
    }

    public static LongStream longParallelStream(Supplier<? extends Spliterator.OfPrimitive<Long>> supplier, int n) {
        return new LongPipeline(supplier, n | StreamOpFlag.IS_PARALLEL);
    }

    public static LongStream longStream(Spliterator.OfPrimitive<Long> ofPrimitive, int n) {
        return new LongPipeline(() -> ofPrimitive, n & ~StreamOpFlag.IS_PARALLEL);
    }

    public static LongStream longParallelStream(Spliterator.OfPrimitive<Long> ofPrimitive, int n) {
        return new LongPipeline(() -> ofPrimitive, n | StreamOpFlag.IS_PARALLEL);
    }

    public static DoubleStream emptyDoubleStream() {
        return Streams.doubleStream((Spliterator.OfPrimitive)Streams.emptyPrimitiveSpliterator(), (int)0);
    }

    public static DoubleStream doubleStream(Supplier<? extends Spliterator.OfPrimitive<Double>> supplier, int n) {
        return new DoublePipeline(supplier, n & ~StreamOpFlag.IS_PARALLEL);
    }

    public static DoubleStream doubleParallelStream(Supplier<? extends Spliterator.OfPrimitive<Double>> supplier, int n) {
        return new DoublePipeline(supplier, n | StreamOpFlag.IS_PARALLEL);
    }

    public static DoubleStream doubleStream(Spliterator.OfPrimitive<Double> ofPrimitive, int n) {
        return new DoublePipeline(() -> ofPrimitive, n & ~StreamOpFlag.IS_PARALLEL);
    }

    public static DoubleStream doubleParallelStream(Spliterator.OfPrimitive<Double> ofPrimitive, int n) {
        return new DoublePipeline(() -> ofPrimitive, n | StreamOpFlag.IS_PARALLEL);
    }

    public static <T> Spliterator<T> emptySpliterator() {
        return new EmptySpliterator(null);
    }

    public static <E> Spliterator.OfPrimitive<E> emptyPrimitiveSpliterator() {
        return new EmptySpliterator.OfPrimitive(null);
    }

    public static <E> PrimitiveIterator<E> emptyPrimitiveIterator() {
        return EMPTY_NUMERIC_ITERATOR;
    }

    public static <T> Iterator<T> iteratorFrom(Spliterator<? extends T> spliterator) {
        return new Adapter(spliterator);
    }

    public static PrimitiveIterator<Integer> intIteratorFrom(Spliterator.OfPrimitive<Integer> ofPrimitive) {
        return new Adapter(ofPrimitive);
    }

    public static PrimitiveIterator<Long> longIteratorFrom(Spliterator.OfPrimitive<Long> ofPrimitive) {
        return new Adapter(ofPrimitive);
    }

    public static PrimitiveIterator<Double> doubleIteratorFrom(Spliterator.OfPrimitive<Double> ofPrimitive) {
        return new Adapter(ofPrimitive);
    }

    public static <T> Spliterator<T> spliterator(final Iterator<T> iterator, final long l) {
        Objects.requireNonNull(iterator);
        return new Runnable(l, iterator){

            @Override
            public void run() {
                try {
                    l.run();
                }
                catch (Throwable e1) {
                    try {
                        iterator.run();
                    }
                    catch (Throwable e2) {
                        try {
                            e1.addSuppressed(e2);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    throw e1;
                }
                iterator.run();
            }
        };
    }

    public static <T> Spliterator<T> spliteratorUnknownSize(Iterator<T> iterator) {
        return Streams.spliterator(iterator, (long)-1L);
    }

    public static Spliterator.OfInt intSpliteratorUnknownSize(PrimitiveIterator<Integer> primitiveIterator) {
        return Streams.intSpliterator(primitiveIterator, (long)-1L);
    }

    public static Spliterator.OfInt intSpliterator(PrimitiveIterator<Integer> primitiveIterator, long l) {
        return new Splitr(l, primitiveIterator);
    }

    public static Spliterator.OfLong longSpliteratorUnknownSize(PrimitiveIterator<Long> primitiveIterator) {
        return Streams.longSpliterator(primitiveIterator, (long)-1L);
    }

    public static Spliterator.OfLong longSpliterator(PrimitiveIterator<Long> primitiveIterator, long l) {
        return new Splitr(l, primitiveIterator);
    }

    public static Spliterator.OfDouble doubleSpliteratorUnknownSize(PrimitiveIterator<Double> primitiveIterator) {
        return Streams.doubleSpliterator(primitiveIterator, (long)-1L);
    }

    public static Spliterator.OfDouble doubleSpliterator(PrimitiveIterator<Double> primitiveIterator, long l) {
        return new Splitr(l, primitiveIterator);
    }

    public static <T> Stream<T> iterate(final T t, final UnaryOperator<T> unaryOperator) {
        Objects.requireNonNull(unaryOperator);
        Runnable runnable = new Runnable(t, unaryOperator){

            @Override
            public void run() {
                try {
                    t.close();
                }
                catch (Throwable e1) {
                    try {
                        unaryOperator.close();
                    }
                    catch (Throwable e2) {
                        try {
                            e1.addSuppressed(e2);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    throw e1;
                }
                unaryOperator.close();
            }
        };
        return Streams.stream((Spliterator)Streams.spliteratorUnknownSize((Iterator)((Object)runnable)), (int)StreamOpFlag.IS_ORDERED);
    }

    public static <T> Stream<T> generate(Supplier<T> supplier) {
        InfiniteIterator infiniteIterator = supplier::get;
        return Streams.stream((Spliterator)Streams.spliteratorUnknownSize((Iterator)infiniteIterator), (int)StreamOpFlag.IS_ORDERED);
    }

    public static IntStream iterateInt(int n, IntUnaryOperator intUnaryOperator) {
        Objects.requireNonNull(intUnaryOperator);
        3 var2_2 = new /* Unavailable Anonymous Inner Class!! */;
        return Streams.intStream((Spliterator.OfPrimitive)Streams.intSpliterator((PrimitiveIterator)var2_2, (long)-1L), (int)StreamOpFlag.IS_ORDERED);
    }

    public static IntStream generateInt(IntSupplier intSupplier) {
        InfiniteIterator.OfInt ofInt = intSupplier::getAsInt;
        return Streams.intStream((Spliterator.OfPrimitive)Streams.intSpliterator((PrimitiveIterator)ofInt, (long)-1L), (int)StreamOpFlag.IS_ORDERED);
    }

    public static IntStream intRange(int n, int n2) {
        return Streams.intRange((int)n, (int)n2, (int)1);
    }

    public static IntStream intRange(int n, int n2, int n3) {
        RangeIntSpliterator rangeIntSpliterator = new RangeIntSpliterator(n, n2, n3);
        return Streams.intStream((Spliterator.OfPrimitive)rangeIntSpliterator, (int)(StreamOpFlag.IS_SIZED | StreamOpFlag.IS_ORDERED));
    }

    public static LongStream iterateLong(long l, LongUnaryOperator longUnaryOperator) {
        Objects.requireNonNull(longUnaryOperator);
        4 var3_2 = new /* Unavailable Anonymous Inner Class!! */;
        return Streams.longStream((Spliterator.OfPrimitive)Streams.longSpliterator((PrimitiveIterator)var3_2, (long)-1L), (int)StreamOpFlag.IS_ORDERED);
    }

    public static LongStream generateLong(LongSupplier longSupplier) {
        InfiniteIterator.OfLong ofLong = longSupplier::getAsLong;
        return Streams.longStream((Spliterator.OfPrimitive)Streams.longSpliterator((PrimitiveIterator)ofLong, (long)-1L), (int)StreamOpFlag.IS_ORDERED);
    }

    public static LongStream longRange(long l, long l2) {
        return Streams.longRange((long)l, (long)l2, (long)1L);
    }

    public static LongStream longRange(long l, long l2, long l3) {
        RangeLongSpliterator rangeLongSpliterator = new RangeLongSpliterator(l, l2, l3);
        return Streams.longStream((Spliterator.OfPrimitive)rangeLongSpliterator, (int)(StreamOpFlag.IS_SIZED | StreamOpFlag.IS_ORDERED));
    }

    public static DoubleStream iterateDouble(double d, DoubleUnaryOperator doubleUnaryOperator) {
        Objects.requireNonNull(doubleUnaryOperator);
        5 var3_2 = new /* Unavailable Anonymous Inner Class!! */;
        return Streams.doubleStream((Spliterator.OfPrimitive)Streams.doubleSpliterator((PrimitiveIterator)var3_2, (long)-1L), (int)StreamOpFlag.IS_ORDERED);
    }

    public static DoubleStream generateDouble(DoubleSupplier doubleSupplier) {
        InfiniteIterator.OfDouble ofDouble = doubleSupplier::getAsDouble;
        return Streams.doubleStream((Spliterator.OfPrimitive)Streams.doubleSpliterator((PrimitiveIterator)ofDouble, (long)-1L), (int)StreamOpFlag.IS_ORDERED);
    }

    public static <T> Stream<T> concat(Stream<? extends T> stream, Stream<? extends T> stream2) {
        Spliterator spliterator = Objects.requireNonNull(stream).spliterator();
        Spliterator spliterator2 = Objects.requireNonNull(stream2).spliterator();
        int n = stream.getStreamFlags() & stream2.getStreamFlags() & StreamOpFlag.IS_ORDERED;
        if (Spliterators.exactSizeIfKnown(spliterator) != -1L && Spliterators.exactSizeIfKnown(spliterator2) != -1L) {
            n |= StreamOpFlag.IS_SIZED;
        }
        6 var5_5 = new /* Unavailable Anonymous Inner Class!! */;
        return stream.isParallel() || stream2.isParallel() ? Streams.parallelStream((Spliterator)var5_5, (int)n) : Streams.stream(() -> Streams.lambda$194((Spliterator)var5_5), (int)n);
    }

    public static <A, B, C> Stream<C> zip(Stream<? extends A> stream, Stream<? extends B> stream2, BiFunction<? super A, ? super B, ? extends C> biFunction) {
        Objects.requireNonNull(biFunction);
        Spliterator spliterator = Objects.requireNonNull(stream).spliterator();
        Spliterator spliterator2 = Objects.requireNonNull(stream2).spliterator();
        int n = stream.getStreamFlags() & stream2.getStreamFlags() & StreamOpFlag.IS_ORDERED;
        long l = -1L;
        if (Spliterators.exactSizeIfKnown(spliterator) != -1L && Spliterators.exactSizeIfKnown(spliterator2) != -1L) {
            n |= StreamOpFlag.IS_SIZED;
            l = Math.min(Spliterators.exactSizeIfKnown(spliterator), Spliterators.exactSizeIfKnown(spliterator2));
        }
        Iterator iterator = Streams.iteratorFrom(spliterator);
        Iterator iterator2 = Streams.iteratorFrom(spliterator2);
        7 var10_9 = new /* Unavailable Anonymous Inner Class!! */;
        Spliterator spliterator3 = Streams.spliterator((Iterator)var10_9, (long)l);
        return stream.isParallel() || stream2.isParallel() ? Streams.parallelStream((Spliterator)spliterator3, (int)n) : Streams.stream((Spliterator)spliterator3, (int)n);
    }

    private static /* synthetic */ Spliterator lambda$194(Spliterator spliterator) {
        return spliterator;
    }

    static final class RangeLongSpliterator
    implements Spliterator.OfLong {
        private long from;
        private final long upTo;
        private int last;
        private static final long BALANCED_SPLIT_THRESHOLD = 0x1000000L;
        private static final long RIGHT_BALANCED_SPLIT_RATIO = 8L;

        RangeLongSpliterator(long from, long upTo, boolean closed) {
            this(from, upTo, closed ? 1 : 0);
        }

        private RangeLongSpliterator(long from, long upTo, int last) {
            assert (upTo - from + (long)last > 0L);
            this.from = from;
            this.upTo = upTo;
            this.last = last;
        }

        @Override
        public boolean tryAdvance(LongConsumer consumer) {
            Objects.requireNonNull(consumer);
            long i = this.from++;
            if (i < this.upTo) {
                consumer.accept(i);
                return true;
            }
            if (this.last > 0) {
                this.last = 0;
                consumer.accept(i);
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(LongConsumer consumer) {
            Objects.requireNonNull(consumer);
            long i = this.from;
            long hUpTo = this.upTo;
            int hLast = this.last;
            this.from = this.upTo;
            this.last = 0;
            while (i < hUpTo) {
                consumer.accept(i++);
            }
            if (hLast > 0) {
                consumer.accept(i);
            }
        }

        @Override
        public long estimateSize() {
            return this.upTo - this.from + (long)this.last;
        }

        @Override
        public int characteristics() {
            return 17749;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            return null;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            long size = this.estimateSize();
            return size <= 1L ? null : new RangeLongSpliterator(this.from, this.from += this.splitPoint(size), 0);
        }

        private long splitPoint(long size) {
            long d = size < 0x1000000L ? 2L : 8L;
            return size / d;
        }
    }

    static final class RangeIntSpliterator
    implements Spliterator.OfInt {
        private int from;
        private final int upTo;
        private int last;
        private static final int BALANCED_SPLIT_THRESHOLD = 0x1000000;
        private static final int RIGHT_BALANCED_SPLIT_RATIO = 8;

        RangeIntSpliterator(int from, int upTo, boolean closed) {
            this(from, upTo, closed ? 1 : 0);
        }

        private RangeIntSpliterator(int from, int upTo, int last) {
            this.from = from;
            this.upTo = upTo;
            this.last = last;
        }

        @Override
        public boolean tryAdvance(IntConsumer consumer) {
            Objects.requireNonNull(consumer);
            int i = this.from++;
            if (i < this.upTo) {
                consumer.accept(i);
                return true;
            }
            if (this.last > 0) {
                this.last = 0;
                consumer.accept(i);
                return true;
            }
            return false;
        }

        @Override
        @IntrinsicCandidate
        public void forEachRemaining(IntConsumer consumer) {
            Objects.requireNonNull(consumer);
            int i = this.from;
            int hUpTo = this.upTo;
            int hLast = this.last;
            this.from = this.upTo;
            this.last = 0;
            while (i < hUpTo) {
                consumer.accept(i++);
            }
            if (hLast > 0) {
                consumer.accept(i);
            }
        }

        @Override
        public long estimateSize() {
            return (long)this.upTo - (long)this.from + (long)this.last;
        }

        @Override
        public int characteristics() {
            return 17749;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            return null;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            long size = this.estimateSize();
            return size <= 1L ? null : new RangeIntSpliterator(this.from, this.from += this.splitPoint(size), 0);
        }

        private int splitPoint(long size) {
            int d = size < 0x1000000L ? 2 : 8;
            return (int)(size / (long)d);
        }
    }
}

