/*
 * Copyright (c) 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @summary Test that OSR correctly handles method with large number of locals
 * @bug 8335662
 * @library /test/lib /
 * @modules java.base/jdk.internal.misc
 *
 * @build jdk.test.whitebox.WhiteBox
 * @run driver jdk.test.lib.helpers.ClassFileInstaller jdk.test.whitebox.WhiteBox
 *
 * @run main/othervm -Xbootclasspath/a:. -XX:+UnlockDiagnosticVMOptions -XX:+WhiteBoxAPI
 *                   compiler.c1.TestOSRLotsOfLocals
 */
package compiler.c1;

import java.lang.reflect.Method;

import jdk.test.whitebox.WhiteBox;

import static compiler.whitebox.CompilerWhiteBoxTest.COMP_LEVEL_SIMPLE;

public class TestOSRLotsOfLocals {

    private static WhiteBox wb = WhiteBox.getWhiteBox();

    public static void main(String... args) throws Exception {
        Method method = TestOSRLotsOfLocals.class.getDeclaredMethod("lotsOfLocals");

        wb.enqueueMethodForCompilation(method, COMP_LEVEL_SIMPLE, 0);
        while (wb.isMethodQueuedForCompilation(method)) {
            Thread.onSpinWait();
        }
    }

    private static synchronized void lotsOfLocals() {
        boolean b0, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, b12, b13, b14, b15, b16, b17, b18, b19, b20, b21, b22, b23, b24, b25, b26, b27, b28, b29, b30, b31, b32, b33, b34, b35, b36, b37, b38, b39, b40, b41, b42, b43, b44, b45, b46, b47, b48, b49, b50, b51, b52, b53, b54, b55, b56, b57, b58, b59, b60, b61, b62, b63, b64, b65, b66, b67, b68, b69, b70, b71, b72, b73, b74, b75, b76, b77, b78, b79, b80, b81, b82, b83, b84, b85, b86, b87, b88, b89, b90, b91, b92, b93, b94, b95, b96, b97, b98, b99,
                b100, b101, b102, b103, b104, b105, b106, b107, b108, b109, b110, b111, b112, b113, b114, b115, b116, b117, b118, b119, b120, b121, b122, b123, b124, b125, b126, b127, b128, b129, b130, b131, b132, b133, b134, b135, b136, b137, b138, b139, b140, b141, b142, b143, b144, b145, b146, b147, b148, b149, b150, b151, b152, b153, b154, b155, b156, b157, b158, b159, b160, b161, b162, b163, b164, b165, b166, b167, b168, b169, b170, b171, b172, b173, b174, b175, b176, b177, b178, b179, b180, b181, b182, b183, b184, b185, b186, b187, b188, b189, b190, b191, b192, b193, b194, b195, b196, b197, b198, b199,
                b200, b201, b202, b203, b204, b205, b206, b207, b208, b209, b210, b211, b212, b213, b214, b215, b216, b217, b218, b219, b220, b221, b222, b223, b224, b225, b226, b227, b228, b229, b230, b231, b232, b233, b234, b235, b236, b237, b238, b239, b240, b241, b242, b243, b244, b245, b246, b247, b248, b249, b250, b251, b252, b253, b254, b255, b256, b257, b258, b259, b260, b261, b262, b263, b264, b265, b266, b267, b268, b269, b270, b271, b272, b273, b274, b275, b276, b277, b278, b279, b280, b281, b282, b283, b284, b285, b286, b287, b288, b289, b290, b291, b292, b293, b294, b295, b296, b297, b298, b299,
                b300, b301, b302, b303, b304, b305, b306, b307, b308, b309, b310, b311, b312, b313, b314, b315, b316, b317, b318, b319, b320, b321, b322, b323, b324, b325, b326, b327, b328, b329, b330, b331, b332, b333, b334, b335, b336, b337, b338, b339, b340, b341, b342, b343, b344, b345, b346, b347, b348, b349, b350, b351, b352, b353, b354, b355, b356, b357, b358, b359, b360, b361, b362, b363, b364, b365, b366, b367, b368, b369, b370, b371, b372, b373, b374, b375, b376, b377, b378, b379, b380, b381, b382, b383, b384, b385, b386, b387, b388, b389, b390, b391, b392, b393, b394, b395, b396, b397, b398, b399,
                b400, b401, b402, b403, b404, b405, b406, b407, b408, b409, b410, b411, b412, b413, b414, b415, b416, b417, b418, b419, b420, b421, b422, b423, b424, b425, b426, b427, b428, b429, b430, b431, b432, b433, b434, b435, b436, b437, b438, b439, b440, b441, b442, b443, b444, b445, b446, b447, b448, b449, b450, b451, b452, b453, b454, b455, b456, b457, b458, b459, b460, b461, b462, b463, b464, b465, b466, b467, b468, b469, b470, b471, b472, b473, b474, b475, b476, b477, b478, b479, b480, b481, b482, b483, b484, b485, b486, b487, b488, b489, b490, b491, b492, b493, b494, b495, b496, b497, b498, b499,
                b500, b501, b502, b503, b504, b505, b506, b507, b508, b509, b510, b511, b512, b513, b514, b515, b516, b517, b518, b519, b520, b521, b522, b523, b524, b525, b526, b527, b528, b529, b530, b531, b532, b533, b534, b535, b536, b537, b538, b539, b540, b541, b542, b543, b544, b545, b546, b547, b548, b549, b550, b551, b552, b553, b554, b555, b556, b557, b558, b559, b560, b561, b562, b563, b564, b565, b566, b567, b568, b569, b570, b571, b572, b573, b574, b575, b576, b577, b578, b579, b580, b581, b582, b583, b584, b585, b586, b587, b588, b589, b590, b591, b592, b593, b594, b595, b596, b597, b598, b599,
                b600, b601, b602, b603, b604, b605, b606, b607, b608, b609, b610, b611, b612, b613, b614, b615, b616, b617, b618, b619, b620, b621, b622, b623, b624, b625, b626, b627, b628, b629, b630, b631, b632, b633, b634, b635, b636, b637, b638, b639, b640, b641, b642, b643, b644, b645, b646, b647, b648, b649, b650, b651, b652, b653, b654, b655, b656, b657, b658, b659, b660, b661, b662, b663, b664, b665, b666, b667, b668, b669, b670, b671, b672, b673, b674, b675, b676, b677, b678, b679, b680, b681, b682, b683, b684, b685, b686, b687, b688, b689, b690, b691, b692, b693, b694, b695, b696, b697, b698, b699,
                b700, b701, b702, b703, b704, b705, b706, b707, b708, b709, b710, b711, b712, b713, b714, b715, b716, b717, b718, b719, b720, b721, b722, b723, b724, b725, b726, b727, b728, b729, b730, b731, b732, b733, b734, b735, b736, b737, b738, b739, b740, b741, b742, b743, b744, b745, b746, b747, b748, b749, b750, b751, b752, b753, b754, b755, b756, b757, b758, b759, b760, b761, b762, b763, b764, b765, b766, b767, b768, b769, b770, b771, b772, b773, b774, b775, b776, b777, b778, b779, b780, b781, b782, b783, b784, b785, b786, b787, b788, b789, b790, b791, b792, b793, b794, b795, b796, b797, b798, b799,
                b800, b801, b802, b803, b804, b805, b806, b807, b808, b809, b810, b811, b812, b813, b814, b815, b816, b817, b818, b819, b820, b821, b822, b823, b824, b825, b826, b827, b828, b829, b830, b831, b832, b833, b834, b835, b836, b837, b838, b839, b840, b841, b842, b843, b844, b845, b846, b847, b848, b849, b850, b851, b852, b853, b854, b855, b856, b857, b858, b859, b860, b861, b862, b863, b864, b865, b866, b867, b868, b869, b870, b871, b872, b873, b874, b875, b876, b877, b878, b879, b880, b881, b882, b883, b884, b885, b886, b887, b888, b889, b890, b891, b892, b893, b894, b895, b896, b897, b898, b899,
                b900, b901, b902, b903, b904, b905, b906, b907, b908, b909, b910, b911, b912, b913, b914, b915, b916, b917, b918, b919, b920, b921, b922, b923, b924, b925, b926, b927, b928, b929, b930, b931, b932, b933, b934, b935, b936, b937, b938, b939, b940, b941, b942, b943, b944, b945, b946, b947, b948, b949, b950, b951, b952, b953, b954, b955, b956, b957, b958, b959, b960, b961, b962, b963, b964, b965, b966, b967, b968, b969, b970, b971, b972, b973, b974, b975, b976, b977, b978, b979, b980, b981, b982, b983, b984, b985, b986, b987, b988, b989, b990, b991, b992, b993, b994, b995, b996, b997, b998, b999,
                b1000, b1001, b1002, b1003, b1004, b1005, b1006, b1007, b1008, b1009, b1010, b1011, b1012, b1013, b1014, b1015, b1016, b1017, b1018, b1019, b1020, b1021, b1022, b1023, b1024, b1025, b1026, b1027, b1028, b1029, b1030, b1031, b1032, b1033, b1034, b1035, b1036, b1037, b1038, b1039, b1040, b1041, b1042, b1043, b1044, b1045, b1046, b1047, b1048, b1049, b1050, b1051, b1052, b1053, b1054, b1055, b1056, b1057, b1058, b1059, b1060, b1061, b1062, b1063, b1064, b1065, b1066, b1067, b1068, b1069, b1070, b1071, b1072, b1073, b1074, b1075, b1076, b1077, b1078, b1079, b1080, b1081, b1082, b1083, b1084, b1085, b1086, b1087, b1088, b1089, b1090, b1091, b1092, b1093, b1094, b1095, b1096, b1097, b1098, b1099,
                b1100, b1101, b1102, b1103, b1104, b1105, b1106, b1107, b1108, b1109, b1110, b1111, b1112, b1113, b1114, b1115, b1116, b1117, b1118, b1119, b1120, b1121, b1122, b1123, b1124, b1125, b1126, b1127, b1128, b1129, b1130, b1131, b1132, b1133, b1134, b1135, b1136, b1137, b1138, b1139, b1140, b1141, b1142, b1143, b1144, b1145, b1146, b1147, b1148, b1149, b1150, b1151, b1152, b1153, b1154, b1155, b1156, b1157, b1158, b1159, b1160, b1161, b1162, b1163, b1164, b1165, b1166, b1167, b1168, b1169, b1170, b1171, b1172, b1173, b1174, b1175, b1176, b1177, b1178, b1179, b1180, b1181, b1182, b1183, b1184, b1185, b1186, b1187, b1188, b1189, b1190, b1191, b1192, b1193, b1194, b1195, b1196, b1197, b1198, b1199,
                b1200, b1201, b1202, b1203, b1204, b1205, b1206, b1207, b1208, b1209, b1210, b1211, b1212, b1213, b1214, b1215, b1216, b1217, b1218, b1219, b1220, b1221, b1222, b1223, b1224, b1225, b1226, b1227, b1228, b1229, b1230, b1231, b1232, b1233, b1234, b1235, b1236, b1237, b1238, b1239, b1240, b1241, b1242, b1243, b1244, b1245, b1246, b1247, b1248, b1249, b1250, b1251, b1252, b1253, b1254, b1255, b1256, b1257, b1258, b1259, b1260, b1261, b1262, b1263, b1264, b1265, b1266, b1267, b1268, b1269, b1270, b1271, b1272, b1273, b1274, b1275, b1276, b1277, b1278, b1279, b1280, b1281, b1282, b1283, b1284, b1285, b1286, b1287, b1288, b1289, b1290, b1291, b1292, b1293, b1294, b1295, b1296, b1297, b1298, b1299,
                b1300, b1301, b1302, b1303, b1304, b1305, b1306, b1307, b1308, b1309, b1310, b1311, b1312, b1313, b1314, b1315, b1316, b1317, b1318, b1319, b1320, b1321, b1322, b1323, b1324, b1325, b1326, b1327, b1328, b1329, b1330, b1331, b1332, b1333, b1334, b1335, b1336, b1337, b1338, b1339, b1340, b1341, b1342, b1343, b1344, b1345, b1346, b1347, b1348, b1349, b1350, b1351, b1352, b1353, b1354, b1355, b1356, b1357, b1358, b1359, b1360, b1361, b1362, b1363, b1364, b1365, b1366, b1367, b1368, b1369, b1370, b1371, b1372, b1373, b1374, b1375, b1376, b1377, b1378, b1379, b1380, b1381, b1382, b1383, b1384, b1385, b1386, b1387, b1388, b1389, b1390, b1391, b1392, b1393, b1394, b1395, b1396, b1397, b1398, b1399,
                b1400, b1401, b1402, b1403, b1404, b1405, b1406, b1407, b1408, b1409, b1410, b1411, b1412, b1413, b1414, b1415, b1416, b1417, b1418, b1419, b1420, b1421, b1422, b1423, b1424, b1425, b1426, b1427, b1428, b1429, b1430, b1431, b1432, b1433, b1434, b1435, b1436, b1437, b1438, b1439, b1440, b1441, b1442, b1443, b1444, b1445, b1446, b1447, b1448, b1449, b1450, b1451, b1452, b1453, b1454, b1455, b1456, b1457, b1458, b1459, b1460, b1461, b1462, b1463, b1464, b1465, b1466, b1467, b1468, b1469, b1470, b1471, b1472, b1473, b1474, b1475, b1476, b1477, b1478, b1479, b1480, b1481, b1482, b1483, b1484, b1485, b1486, b1487, b1488, b1489, b1490, b1491, b1492, b1493, b1494, b1495, b1496, b1497, b1498, b1499,
                b1500, b1501, b1502, b1503, b1504, b1505, b1506, b1507, b1508, b1509, b1510, b1511, b1512, b1513, b1514, b1515, b1516, b1517, b1518, b1519, b1520, b1521, b1522, b1523, b1524, b1525, b1526, b1527, b1528, b1529, b1530, b1531, b1532, b1533, b1534, b1535, b1536, b1537, b1538, b1539, b1540, b1541, b1542, b1543, b1544, b1545, b1546, b1547, b1548, b1549, b1550, b1551, b1552, b1553, b1554, b1555, b1556, b1557, b1558, b1559, b1560, b1561, b1562, b1563, b1564, b1565, b1566, b1567, b1568, b1569, b1570, b1571, b1572, b1573, b1574, b1575, b1576, b1577, b1578, b1579, b1580, b1581, b1582, b1583, b1584, b1585, b1586, b1587, b1588, b1589, b1590, b1591, b1592, b1593, b1594, b1595, b1596, b1597, b1598, b1599,
                b1600, b1601, b1602, b1603, b1604, b1605, b1606, b1607, b1608, b1609, b1610, b1611, b1612, b1613, b1614, b1615, b1616, b1617, b1618, b1619, b1620, b1621, b1622, b1623, b1624, b1625, b1626, b1627, b1628, b1629, b1630, b1631, b1632, b1633, b1634, b1635, b1636, b1637, b1638, b1639, b1640, b1641, b1642, b1643, b1644, b1645, b1646, b1647, b1648, b1649, b1650, b1651, b1652, b1653, b1654, b1655, b1656, b1657, b1658, b1659, b1660, b1661, b1662, b1663, b1664, b1665, b1666, b1667, b1668, b1669, b1670, b1671, b1672, b1673, b1674, b1675, b1676, b1677, b1678, b1679, b1680, b1681, b1682, b1683, b1684, b1685, b1686, b1687, b1688, b1689, b1690, b1691, b1692, b1693, b1694, b1695, b1696, b1697, b1698, b1699,
                b1700, b1701, b1702, b1703, b1704, b1705, b1706, b1707, b1708, b1709, b1710, b1711, b1712, b1713, b1714, b1715, b1716, b1717, b1718, b1719, b1720, b1721, b1722, b1723, b1724, b1725, b1726, b1727, b1728, b1729, b1730, b1731, b1732, b1733, b1734, b1735, b1736, b1737, b1738, b1739, b1740, b1741, b1742, b1743, b1744, b1745, b1746, b1747, b1748, b1749, b1750, b1751, b1752, b1753, b1754, b1755, b1756, b1757, b1758, b1759, b1760, b1761, b1762, b1763, b1764, b1765, b1766, b1767, b1768, b1769, b1770, b1771, b1772, b1773, b1774, b1775, b1776, b1777, b1778, b1779, b1780, b1781, b1782, b1783, b1784, b1785, b1786, b1787, b1788, b1789, b1790, b1791, b1792, b1793, b1794, b1795, b1796, b1797, b1798, b1799,
                b1800, b1801, b1802, b1803, b1804, b1805, b1806, b1807, b1808, b1809, b1810, b1811, b1812, b1813, b1814, b1815, b1816, b1817, b1818, b1819, b1820, b1821, b1822, b1823, b1824, b1825, b1826, b1827, b1828, b1829, b1830, b1831, b1832, b1833, b1834, b1835, b1836, b1837, b1838, b1839, b1840, b1841, b1842, b1843, b1844, b1845, b1846, b1847, b1848, b1849, b1850, b1851, b1852, b1853, b1854, b1855, b1856, b1857, b1858, b1859, b1860, b1861, b1862, b1863, b1864, b1865, b1866, b1867, b1868, b1869, b1870, b1871, b1872, b1873, b1874, b1875, b1876, b1877, b1878, b1879, b1880, b1881, b1882, b1883, b1884, b1885, b1886, b1887, b1888, b1889, b1890, b1891, b1892, b1893, b1894, b1895, b1896, b1897, b1898, b1899,
                b1900, b1901, b1902, b1903, b1904, b1905, b1906, b1907, b1908, b1909, b1910, b1911, b1912, b1913, b1914, b1915, b1916, b1917, b1918, b1919, b1920, b1921, b1922, b1923, b1924, b1925, b1926, b1927, b1928, b1929, b1930, b1931, b1932, b1933, b1934, b1935, b1936, b1937, b1938, b1939, b1940, b1941, b1942, b1943, b1944, b1945, b1946, b1947, b1948, b1949, b1950, b1951, b1952, b1953, b1954, b1955, b1956, b1957, b1958, b1959, b1960, b1961, b1962, b1963, b1964, b1965, b1966, b1967, b1968, b1969, b1970, b1971, b1972, b1973, b1974, b1975, b1976, b1977, b1978, b1979, b1980, b1981, b1982, b1983, b1984, b1985, b1986, b1987, b1988, b1989, b1990, b1991, b1992, b1993, b1994, b1995, b1996, b1997, b1998, b1999,
                b2000, b2001, b2002, b2003, b2004, b2005, b2006, b2007, b2008, b2009, b2010, b2011, b2012, b2013, b2014, b2015, b2016, b2017, b2018, b2019, b2020, b2021, b2022, b2023, b2024, b2025, b2026, b2027, b2028, b2029, b2030, b2031, b2032, b2033, b2034, b2035, b2036, b2037, b2038, b2039, b2040, b2041, b2042, b2043, b2044, b2045, b2046, b2047, b2048, b2049, b2050, b2051, b2052, b2053, b2054, b2055, b2056, b2057, b2058, b2059, b2060, b2061, b2062, b2063, b2064, b2065, b2066, b2067, b2068, b2069, b2070, b2071, b2072, b2073, b2074, b2075, b2076, b2077, b2078, b2079, b2080, b2081, b2082, b2083, b2084, b2085, b2086, b2087, b2088, b2089, b2090, b2091, b2092, b2093, b2094, b2095, b2096, b2097, b2098, b2099,
                b2100, b2101, b2102, b2103, b2104, b2105, b2106, b2107, b2108, b2109, b2110, b2111, b2112, b2113, b2114, b2115, b2116, b2117, b2118, b2119, b2120, b2121, b2122, b2123, b2124, b2125, b2126, b2127, b2128, b2129, b2130, b2131, b2132, b2133, b2134, b2135, b2136, b2137, b2138, b2139, b2140, b2141, b2142, b2143, b2144, b2145, b2146, b2147, b2148, b2149, b2150, b2151, b2152, b2153, b2154, b2155, b2156, b2157, b2158, b2159, b2160, b2161, b2162, b2163, b2164, b2165, b2166, b2167, b2168, b2169, b2170, b2171, b2172, b2173, b2174, b2175, b2176, b2177, b2178, b2179, b2180, b2181, b2182, b2183, b2184, b2185, b2186, b2187, b2188, b2189, b2190, b2191, b2192, b2193, b2194, b2195, b2196, b2197, b2198, b2199,
                b2200, b2201, b2202, b2203, b2204, b2205, b2206, b2207, b2208, b2209, b2210, b2211, b2212, b2213, b2214, b2215, b2216, b2217, b2218, b2219, b2220, b2221, b2222, b2223, b2224, b2225, b2226, b2227, b2228, b2229, b2230, b2231, b2232, b2233, b2234, b2235, b2236, b2237, b2238, b2239, b2240, b2241, b2242, b2243, b2244, b2245, b2246, b2247, b2248, b2249, b2250, b2251, b2252, b2253, b2254, b2255, b2256, b2257, b2258, b2259, b2260, b2261, b2262, b2263, b2264, b2265, b2266, b2267, b2268, b2269, b2270, b2271, b2272, b2273, b2274, b2275, b2276, b2277, b2278, b2279, b2280, b2281, b2282, b2283, b2284, b2285, b2286, b2287, b2288, b2289, b2290, b2291, b2292, b2293, b2294, b2295, b2296, b2297, b2298, b2299,
                b2300, b2301, b2302, b2303, b2304, b2305, b2306, b2307, b2308, b2309, b2310, b2311, b2312, b2313, b2314, b2315, b2316, b2317, b2318, b2319, b2320, b2321, b2322, b2323, b2324, b2325, b2326, b2327, b2328, b2329, b2330, b2331, b2332, b2333, b2334, b2335, b2336, b2337, b2338, b2339, b2340, b2341, b2342, b2343, b2344, b2345, b2346, b2347, b2348, b2349, b2350, b2351, b2352, b2353, b2354, b2355, b2356, b2357, b2358, b2359, b2360, b2361, b2362, b2363, b2364, b2365, b2366, b2367, b2368, b2369, b2370, b2371, b2372, b2373, b2374, b2375, b2376, b2377, b2378, b2379, b2380, b2381, b2382, b2383, b2384, b2385, b2386, b2387, b2388, b2389, b2390, b2391, b2392, b2393, b2394, b2395, b2396, b2397, b2398, b2399,
                b2400, b2401, b2402, b2403, b2404, b2405, b2406, b2407, b2408, b2409, b2410, b2411, b2412, b2413, b2414, b2415, b2416, b2417, b2418, b2419, b2420, b2421, b2422, b2423, b2424, b2425, b2426, b2427, b2428, b2429, b2430, b2431, b2432, b2433, b2434, b2435, b2436, b2437, b2438, b2439, b2440, b2441, b2442, b2443, b2444, b2445, b2446, b2447, b2448, b2449, b2450, b2451, b2452, b2453, b2454, b2455, b2456, b2457, b2458, b2459, b2460, b2461, b2462, b2463, b2464, b2465, b2466, b2467, b2468, b2469, b2470, b2471, b2472, b2473, b2474, b2475, b2476, b2477, b2478, b2479, b2480, b2481, b2482, b2483, b2484, b2485, b2486, b2487, b2488, b2489, b2490, b2491, b2492, b2493, b2494, b2495, b2496, b2497, b2498, b2499,
                b2500, b2501, b2502, b2503, b2504, b2505, b2506, b2507, b2508, b2509, b2510, b2511, b2512, b2513, b2514, b2515, b2516, b2517, b2518, b2519, b2520, b2521, b2522, b2523, b2524, b2525, b2526, b2527, b2528, b2529, b2530, b2531, b2532, b2533, b2534, b2535, b2536, b2537, b2538, b2539, b2540, b2541, b2542, b2543, b2544, b2545, b2546, b2547, b2548, b2549, b2550, b2551, b2552, b2553, b2554, b2555, b2556, b2557, b2558, b2559, b2560, b2561, b2562, b2563, b2564, b2565, b2566, b2567, b2568, b2569, b2570, b2571, b2572, b2573, b2574, b2575, b2576, b2577, b2578, b2579, b2580, b2581, b2582, b2583, b2584, b2585, b2586, b2587, b2588, b2589, b2590, b2591, b2592, b2593, b2594, b2595, b2596, b2597, b2598, b2599,
                b2600, b2601, b2602, b2603, b2604, b2605, b2606, b2607, b2608, b2609, b2610, b2611, b2612, b2613, b2614, b2615, b2616, b2617, b2618, b2619, b2620, b2621, b2622, b2623, b2624, b2625, b2626, b2627, b2628, b2629, b2630, b2631, b2632, b2633, b2634, b2635, b2636, b2637, b2638, b2639, b2640, b2641, b2642, b2643, b2644, b2645, b2646, b2647, b2648, b2649, b2650, b2651, b2652, b2653, b2654, b2655, b2656, b2657, b2658, b2659, b2660, b2661, b2662, b2663, b2664, b2665, b2666, b2667, b2668, b2669, b2670, b2671, b2672, b2673, b2674, b2675, b2676, b2677, b2678, b2679, b2680, b2681, b2682, b2683, b2684, b2685, b2686, b2687, b2688, b2689, b2690, b2691, b2692, b2693, b2694, b2695, b2696, b2697, b2698, b2699,
                b2700, b2701, b2702, b2703, b2704, b2705, b2706, b2707, b2708, b2709, b2710, b2711, b2712, b2713, b2714, b2715, b2716, b2717, b2718, b2719, b2720, b2721, b2722, b2723, b2724, b2725, b2726, b2727, b2728, b2729, b2730, b2731, b2732, b2733, b2734, b2735, b2736, b2737, b2738, b2739, b2740, b2741, b2742, b2743, b2744, b2745, b2746, b2747, b2748, b2749, b2750, b2751, b2752, b2753, b2754, b2755, b2756, b2757, b2758, b2759, b2760, b2761, b2762, b2763, b2764, b2765, b2766, b2767, b2768, b2769, b2770, b2771, b2772, b2773, b2774, b2775, b2776, b2777, b2778, b2779, b2780, b2781, b2782, b2783, b2784, b2785, b2786, b2787, b2788, b2789, b2790, b2791, b2792, b2793, b2794, b2795, b2796, b2797, b2798, b2799,
                b2800, b2801, b2802, b2803, b2804, b2805, b2806, b2807, b2808, b2809, b2810, b2811, b2812, b2813, b2814, b2815, b2816, b2817, b2818, b2819, b2820, b2821, b2822, b2823, b2824, b2825, b2826, b2827, b2828, b2829, b2830, b2831, b2832, b2833, b2834, b2835, b2836, b2837, b2838, b2839, b2840, b2841, b2842, b2843, b2844, b2845, b2846, b2847, b2848, b2849, b2850, b2851, b2852, b2853, b2854, b2855, b2856, b2857, b2858, b2859, b2860, b2861, b2862, b2863, b2864, b2865, b2866, b2867, b2868, b2869, b2870, b2871, b2872, b2873, b2874, b2875, b2876, b2877, b2878, b2879, b2880, b2881, b2882, b2883, b2884, b2885, b2886, b2887, b2888, b2889, b2890, b2891, b2892, b2893, b2894, b2895, b2896, b2897, b2898, b2899,
                b2900, b2901, b2902, b2903, b2904, b2905, b2906, b2907, b2908, b2909, b2910, b2911, b2912, b2913, b2914, b2915, b2916, b2917, b2918, b2919, b2920, b2921, b2922, b2923, b2924, b2925, b2926, b2927, b2928, b2929, b2930, b2931, b2932, b2933, b2934, b2935, b2936, b2937, b2938, b2939, b2940, b2941, b2942, b2943, b2944, b2945, b2946, b2947, b2948, b2949, b2950, b2951, b2952, b2953, b2954, b2955, b2956, b2957, b2958, b2959, b2960, b2961, b2962, b2963, b2964, b2965, b2966, b2967, b2968, b2969, b2970, b2971, b2972, b2973, b2974, b2975, b2976, b2977, b2978, b2979, b2980, b2981, b2982, b2983, b2984, b2985, b2986, b2987, b2988, b2989, b2990, b2991, b2992, b2993, b2994, b2995, b2996, b2997, b2998, b2999,
                b3000, b3001, b3002, b3003, b3004, b3005, b3006, b3007, b3008, b3009, b3010, b3011, b3012, b3013, b3014, b3015, b3016, b3017, b3018, b3019, b3020, b3021, b3022, b3023, b3024, b3025, b3026, b3027, b3028, b3029, b3030, b3031, b3032, b3033, b3034, b3035, b3036, b3037, b3038, b3039, b3040, b3041, b3042, b3043, b3044, b3045, b3046, b3047, b3048, b3049, b3050, b3051, b3052, b3053, b3054, b3055, b3056, b3057, b3058, b3059, b3060, b3061, b3062, b3063, b3064, b3065, b3066, b3067, b3068, b3069, b3070, b3071, b3072, b3073, b3074, b3075, b3076, b3077, b3078, b3079, b3080, b3081, b3082, b3083, b3084, b3085, b3086, b3087, b3088, b3089, b3090, b3091, b3092, b3093, b3094, b3095, b3096, b3097, b3098, b3099,
                b3100, b3101, b3102, b3103, b3104, b3105, b3106, b3107, b3108, b3109, b3110, b3111, b3112, b3113, b3114, b3115, b3116, b3117, b3118, b3119, b3120, b3121, b3122, b3123, b3124, b3125, b3126, b3127, b3128, b3129, b3130, b3131, b3132, b3133, b3134, b3135, b3136, b3137, b3138, b3139, b3140, b3141, b3142, b3143, b3144, b3145, b3146, b3147, b3148, b3149, b3150, b3151, b3152, b3153, b3154, b3155, b3156, b3157, b3158, b3159, b3160, b3161, b3162, b3163, b3164, b3165, b3166, b3167, b3168, b3169, b3170, b3171, b3172, b3173, b3174, b3175, b3176, b3177, b3178, b3179, b3180, b3181, b3182, b3183, b3184, b3185, b3186, b3187, b3188, b3189, b3190, b3191, b3192, b3193, b3194, b3195, b3196, b3197, b3198, b3199,
                b3200, b3201, b3202, b3203, b3204, b3205, b3206, b3207, b3208, b3209, b3210, b3211, b3212, b3213, b3214, b3215, b3216, b3217, b3218, b3219, b3220, b3221, b3222, b3223, b3224, b3225, b3226, b3227, b3228, b3229, b3230, b3231, b3232, b3233, b3234, b3235, b3236, b3237, b3238, b3239, b3240, b3241, b3242, b3243, b3244, b3245, b3246, b3247, b3248, b3249, b3250, b3251, b3252, b3253, b3254, b3255, b3256, b3257, b3258, b3259, b3260, b3261, b3262, b3263, b3264, b3265, b3266, b3267, b3268, b3269, b3270, b3271, b3272, b3273, b3274, b3275, b3276, b3277, b3278, b3279, b3280, b3281, b3282, b3283, b3284, b3285, b3286, b3287, b3288, b3289, b3290, b3291, b3292, b3293, b3294, b3295, b3296, b3297, b3298, b3299,
                b3300, b3301, b3302, b3303, b3304, b3305, b3306, b3307, b3308, b3309, b3310, b3311, b3312, b3313, b3314, b3315, b3316, b3317, b3318, b3319, b3320, b3321, b3322, b3323, b3324, b3325, b3326, b3327, b3328, b3329, b3330, b3331, b3332, b3333, b3334, b3335, b3336, b3337, b3338, b3339, b3340, b3341, b3342, b3343, b3344, b3345, b3346, b3347, b3348, b3349, b3350, b3351, b3352, b3353, b3354, b3355, b3356, b3357, b3358, b3359, b3360, b3361, b3362, b3363, b3364, b3365, b3366, b3367, b3368, b3369, b3370, b3371, b3372, b3373, b3374, b3375, b3376, b3377, b3378, b3379, b3380, b3381, b3382, b3383, b3384, b3385, b3386, b3387, b3388, b3389, b3390, b3391, b3392, b3393, b3394, b3395, b3396, b3397, b3398, b3399,
                b3400, b3401, b3402, b3403, b3404, b3405, b3406, b3407, b3408, b3409, b3410, b3411, b3412, b3413, b3414, b3415, b3416, b3417, b3418, b3419, b3420, b3421, b3422, b3423, b3424, b3425, b3426, b3427, b3428, b3429, b3430, b3431, b3432, b3433, b3434, b3435, b3436, b3437, b3438, b3439, b3440, b3441, b3442, b3443, b3444, b3445, b3446, b3447, b3448, b3449, b3450, b3451, b3452, b3453, b3454, b3455, b3456, b3457, b3458, b3459, b3460, b3461, b3462, b3463, b3464, b3465, b3466, b3467, b3468, b3469, b3470, b3471, b3472, b3473, b3474, b3475, b3476, b3477, b3478, b3479, b3480, b3481, b3482, b3483, b3484, b3485, b3486, b3487, b3488, b3489, b3490, b3491, b3492, b3493, b3494, b3495, b3496, b3497, b3498, b3499,
                b3500, b3501, b3502, b3503, b3504, b3505, b3506, b3507, b3508, b3509, b3510, b3511, b3512, b3513, b3514, b3515, b3516, b3517, b3518, b3519, b3520, b3521, b3522, b3523, b3524, b3525, b3526, b3527, b3528, b3529, b3530, b3531, b3532, b3533, b3534, b3535, b3536, b3537, b3538, b3539, b3540, b3541, b3542, b3543, b3544, b3545, b3546, b3547, b3548, b3549, b3550, b3551, b3552, b3553, b3554, b3555, b3556, b3557, b3558, b3559, b3560, b3561, b3562, b3563, b3564, b3565, b3566, b3567, b3568, b3569, b3570, b3571, b3572, b3573, b3574, b3575, b3576, b3577, b3578, b3579, b3580, b3581, b3582, b3583, b3584, b3585, b3586, b3587, b3588, b3589, b3590, b3591, b3592, b3593, b3594, b3595, b3596, b3597, b3598, b3599,
                b3600, b3601, b3602, b3603, b3604, b3605, b3606, b3607, b3608, b3609, b3610, b3611, b3612, b3613, b3614, b3615, b3616, b3617, b3618, b3619, b3620, b3621, b3622, b3623, b3624, b3625, b3626, b3627, b3628, b3629, b3630, b3631, b3632, b3633, b3634, b3635, b3636, b3637, b3638, b3639, b3640, b3641, b3642, b3643, b3644, b3645, b3646, b3647, b3648, b3649, b3650, b3651, b3652, b3653, b3654, b3655, b3656, b3657, b3658, b3659, b3660, b3661, b3662, b3663, b3664, b3665, b3666, b3667, b3668, b3669, b3670, b3671, b3672, b3673, b3674, b3675, b3676, b3677, b3678, b3679, b3680, b3681, b3682, b3683, b3684, b3685, b3686, b3687, b3688, b3689, b3690, b3691, b3692, b3693, b3694, b3695, b3696, b3697, b3698, b3699,
                b3700, b3701, b3702, b3703, b3704, b3705, b3706, b3707, b3708, b3709, b3710, b3711, b3712, b3713, b3714, b3715, b3716, b3717, b3718, b3719, b3720, b3721, b3722, b3723, b3724, b3725, b3726, b3727, b3728, b3729, b3730, b3731, b3732, b3733, b3734, b3735, b3736, b3737, b3738, b3739, b3740, b3741, b3742, b3743, b3744, b3745, b3746, b3747, b3748, b3749, b3750, b3751, b3752, b3753, b3754, b3755, b3756, b3757, b3758, b3759, b3760, b3761, b3762, b3763, b3764, b3765, b3766, b3767, b3768, b3769, b3770, b3771, b3772, b3773, b3774, b3775, b3776, b3777, b3778, b3779, b3780, b3781, b3782, b3783, b3784, b3785, b3786, b3787, b3788, b3789, b3790, b3791, b3792, b3793, b3794, b3795, b3796, b3797, b3798, b3799,
                b3800, b3801, b3802, b3803, b3804, b3805, b3806, b3807, b3808, b3809, b3810, b3811, b3812, b3813, b3814, b3815, b3816, b3817, b3818, b3819, b3820, b3821, b3822, b3823, b3824, b3825, b3826, b3827, b3828, b3829, b3830, b3831, b3832, b3833, b3834, b3835, b3836, b3837, b3838, b3839, b3840, b3841, b3842, b3843, b3844, b3845, b3846, b3847, b3848, b3849, b3850, b3851, b3852, b3853, b3854, b3855, b3856, b3857, b3858, b3859, b3860, b3861, b3862, b3863, b3864, b3865, b3866, b3867, b3868, b3869, b3870, b3871, b3872, b3873, b3874, b3875, b3876, b3877, b3878, b3879, b3880, b3881, b3882, b3883, b3884, b3885, b3886, b3887, b3888, b3889, b3890, b3891, b3892, b3893, b3894, b3895, b3896, b3897, b3898, b3899,
                b3900, b3901, b3902, b3903, b3904, b3905, b3906, b3907, b3908, b3909, b3910, b3911, b3912, b3913, b3914, b3915, b3916, b3917, b3918, b3919, b3920, b3921, b3922, b3923, b3924, b3925, b3926, b3927, b3928, b3929, b3930, b3931, b3932, b3933, b3934, b3935, b3936, b3937, b3938, b3939, b3940, b3941, b3942, b3943, b3944, b3945, b3946, b3947, b3948, b3949, b3950, b3951, b3952, b3953, b3954, b3955, b3956, b3957, b3958, b3959, b3960, b3961, b3962, b3963, b3964, b3965, b3966, b3967, b3968, b3969, b3970, b3971, b3972, b3973, b3974, b3975, b3976, b3977, b3978, b3979, b3980, b3981, b3982, b3983, b3984, b3985, b3986, b3987, b3988, b3989, b3990, b3991, b3992, b3993, b3994, b3995, b3996, b3997, b3998, b3999,
                b4000, b4001, b4002, b4003, b4004, b4005, b4006, b4007, b4008, b4009, b4010, b4011, b4012, b4013, b4014, b4015, b4016, b4017, b4018, b4019, b4020, b4021, b4022, b4023, b4024, b4025, b4026, b4027, b4028, b4029, b4030, b4031, b4032, b4033, b4034, b4035, b4036, b4037, b4038, b4039, b4040, b4041, b4042, b4043, b4044, b4045, b4046, b4047, b4048, b4049, b4050, b4051, b4052, b4053, b4054, b4055, b4056, b4057, b4058, b4059, b4060, b4061, b4062, b4063, b4064, b4065, b4066, b4067, b4068, b4069, b4070, b4071, b4072, b4073, b4074, b4075, b4076, b4077, b4078, b4079, b4080, b4081, b4082, b4083, b4084, b4085, b4086, b4087, b4088, b4089, b4090, b4091, b4092, b4093, b4094, b4095, b4096, b4097, b4098, b4099;
    }

}
