/***************************************************************************
 *   Copyright (C) 2008 by BogDan Vatra                                    *
 *   bogdan@licentia.eu                                                    *
 *                                                                         *
 *   This program is free software: you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#include <QDebug>
#include "barcodeitem.h"

BarcodeItem::BarcodeItem()
		: QGraphicsItem()
{
	w=550;
	h=230;
}


BarcodeItem::~BarcodeItem()
{
}

QRectF BarcodeItem::boundingRect() const
{
	return QRectF(0, 0, w, h);
}

void BarcodeItem::paint(QPainter * painter, const QStyleOptionGraphicsItem * /*option*/, QWidget * /*widget*/)
{
	bc.render(*painter,boundingRect(),ar);
}

void BarcodeItem::paint(QPainter * painter, const QRectF &r)
{
    bc.render(*painter,r,ar);
}
