//                                               -*- C++ -*-
/**
 *  @file  t_OrderStatisticsMarginalChecker.cxx
 *  @brief The test file of class OrderStatisticsMarginalChecker for standard methods
 *
 *  Copyright 2005-2015 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author schueller
 *  @date   2012-07-16 15:59:45 +0200 (Mon, 16 Jul 2012)
 */
#include "OT.hxx"
#include "OTtestcode.hxx"

using namespace OT;
using namespace OT::Test;


inline void checkMarginals(const ComposedDistribution::DistributionCollection& coll)
{
  OStream fullprint(std::cout);
  OrderStatisticsMarginalChecker osmc(coll);
  fullprint << "marginals=" << coll << std::endl;
  fullprint << "isCompatible=" << osmc.isCompatible() << std::endl;
  fullprint << "partition=" << osmc.buildPartition() << std::endl;
}

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  setRandomGenerator();

  try
  {
    ComposedDistribution::DistributionCollection coll;
    coll.add(Uniform(-1., 1.));
    coll.add(LogUniform(1., 1.2));
    coll.add(Triangular(3., 4., 5.));
    coll.add(Uniform(5., 6.));
    coll.add(Uniform(5.5, 6.5));
    checkMarginals(coll);
    coll.add(Uniform(0., 1.0));
    checkMarginals(coll);
  }
  catch (TestFailed & ex)
  {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
