###############################################################################
# OpenVAS Vulnerability Test
# $Id: cisco_vpn_client_win_37077.nasl 7876 2010-06-01 11:02:32Z mime $
#
# Cisco VPN Client for Windows 'StartServiceCtrlDispatche' Local Denial of Service Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100357);
 script_tag(name:"cvss_base", value:"2.1");
 script_cve_id("CVE-2009-4118");
 script_bugtraq_id(37077);
 script_version ("1.0-$Revision: 7876 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Cisco VPN Client for Windows 'StartServiceCtrlDispatche' Local Denial of Service Vulnerability");

desc = "Overview:
Cisco VPN Client for Windows is prone to a local denial-of-service
vulnerability.

A local attacker can exploit this issue to crash the application,
resulting in a denial-of-service condition.

This issue affects Cisco VPN Client for Windows versions prior
5.0.06.0100.

Solution:
Vendor updates are available. Please see the references for more
information.

References:
http://www.securityfocus.com/bid/37077
http://www.cisco.com/warp/public/cc/pd/sqsw/vpncl/index.shtml
http://tools.cisco.com/security/center/viewAlert.x?alertId=19445

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Cisco VPN Client version is < 5.0.06.0100");
 script_category(ACT_GATHER_INFO);
 script_family("Denial of Service");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("cisco_vpn_client_detect.nasl");
 script_require_ports(139, 445);
 script_require_keys("SMB/login", "SMB/password", "SMB/name", "SMB/transport");
 exit(0);
}

include("version_func.inc");

if(!version = get_kb_item("SMB/CiscoVPNClient/Version"))exit(0);

if(version_is_less(version:version, test_version:"5.0.06.0100")){
  security_warning(0);
  exit(0);
}  

exit(0);

