# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1957-1 (aria2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66598);
 script_cve_id("CVE-2009-3575");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Debian Security Advisory DSA 1957-1 (aria2)");

 desc = "The remote host is missing an update to aria2
announced via advisory DSA 1957-1.

It was discovered that aria2, a high speed download utility, is prone
to a buffer overflow in the DHT routing code, which might lead to the
execution of arbitrary code.

For the stable distribution (lenny), this problem has been fixed in
version 0.14.0-1+lenny1. Binaries for powerpc, arm, ia64 and hppa will
be provided once they are available.

The oldstable distribution (etch) is not affected by this problem.

For the testing distribution (squeeze) and the unstable distribution
(sid), this problem has been fixed in version 1.2.0-1.


We recommend that you upgrade your aria2 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201957-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1957-1 (aria2)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"aria2", ver:"0.14.0-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
