# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 230-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53722);
 script_cve_id("CVE-2003-0012", "CVE-2003-0013");
 script_bugtraq_id(6501,6502);
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 230-1 (bugzilla)";
 script_name(name);

 desc = "The remote host is missing an update to bugzilla
announced via advisory DSA 230-1.

Two vulnerabilities have been discovered in Bugzilla, a web-based bug
tracking system, by its authors.  The Common Vulnerabilities and
Exposures Project identifies the following vulnerabilities:

* CVE-2003-0012 (BugTraq ID 6502): The provided data collection
script intended to be run as a nightly cron job changes the
permissions of the data/mining directory to be world-writable every
time it runs.  This would enable local users to alter or delete the
collected data.

* CVE-2003-0013 (BugTraq ID 6501): The default .htaccess scripts
provided by checksetup.pl do not block access to backups of the
localconfig file that might be created by editors such as vi or
emacs (typically these will have a .swp or ~ suffix).  This allows
an end user to download one of the backup copies and potentially
obtain your database password.

This does not affect the Debian installation because there is no
.htaccess as all data file aren't under the CGI path as they are on
the standard Bugzilla package.  Additionally, the configuration is
in /etc/bugzilla/localconfig and hence outside of the web directory.

For the current stable distribution (woody) these problems have been
fixed in version 2.14.2-0woody4.

The old stable distribution (potato) does not contain a Bugzilla
package.

For the unstable distribution (sid) this problem will be fixed soon.

We recommend that you upgrade your bugzilla packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20230-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 230-1 (bugzilla)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"bugzilla-doc", ver:"2.14.2-0woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bugzilla", ver:"2.14.2-0woody4", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
