# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 494-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53688);
 script_bugtraq_id(10192);
 script_cve_id("CVE-2004-0408");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 494-1 (ident2)";
 script_name(name);

 desc = "The remote host is missing an update to ident2
announced via advisory DSA 494-1.

Jack <jack@rapturesecurity.org> discovered a buffer overflow in
ident2, an implementation of the ident protocol (RFC1413), where a
buffer in the child_service function was slightly too small to hold
all of the data which could be written into it.  This vulnerability
could be exploited by a remote attacker to execute arbitrary code with
the privileges of the ident2 daemon (by default, the 'identd' user).

For the current stable distribution (woody) this problem has been
fixed in version 1.03-3woody1.

For the unstable distribution (sid), this problem will be fixed soon.

We recommend that you update your ident2 package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20494-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 494-1 (ident2)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ident2", ver:"1.03-3woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
