###############################################################################
# OpenVAS Vulnerability Test
# $Id: eggdrop_detect.nasl 7287 2010-04-13 15:13:26Z chandra $
#
# Eggdrop Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "

 Overview:
  This Host is running Eggdrop, an Open Source IRC bot.

 See also:
  http://www.eggheads.org/

 Risk factor : None";

if (description)
{
 script_id(100206);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"None");

 script_name("Eggdrop Detection");  

 script_description(desc);
 script_summary("Checks for the presence of Eggdrop");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes");
 script_require_ports("Services/eggdrop",3333 );
 exit(0);
}

include("global_settings.inc");
include("telnet_func.inc");

port = get_kb_item("Services/eggdrop");

if(!port) {
 port = 3333;
}  

if(!get_port_state(port))exit(0);

banner = get_telnet_banner(port:port);

if(isnull(banner)) {
   exit(0);
}   

 if(egrep(pattern:"Eggdrop", string: banner, icase:TRUE)) {

      version = eregmatch(string: banner, pattern: "\(Eggdrop v([0-9.]+[^ ]*) \(",icase:TRUE);

      if ( !isnull(version[1]) ) {
         vers=version[1];
      } 

      set_kb_item(name: string("eggdrop/version/", port), value: vers);

      info = string("None\n\nEggdrop Version '");
      info += string(vers);
      info += string("' was detected on the remote host\n");

      desc = ereg_replace(
          string:desc,
          pattern:"None$",
          replace:info
      );    
       
         if(report_verbosity > 0) {
           security_note(port:port,data:string(desc));
           exit(0);
         }	 

}	 
exit(0);
