# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-12968 (nss-util)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66497);
 script_cve_id("CVE-2009-3555");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"6.4");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 12 FEDORA-2009-12968 (nss-util)");

 desc = "The remote host is missing an update to nss-util
announced via advisory FEDORA-2009-12968.

Update Information:

Update to 3.12.5    This update fixes the following security flaw:
CVE-2009-3555 TLS: MITM attacks via session renegotiation

ChangeLog:

* Thu Dec  3 2009 Elio Maldonado - 3.12.5-1.1
- Update to 3.12.5

References:

[ 1 ] Bug #533125 - CVE-2009-3555 TLS: MITM attacks via session renegotiation
https://bugzilla.redhat.com/show_bug.cgi?id=533125

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update nss-util' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-12968

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 12 FEDORA-2009-12968 (nss-util)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"nss-util", rpm:"nss-util~3.12.5~1.fc12.1", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nss-util-devel", rpm:"nss-util-devel~3.12.5~1.fc12.1", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nss-util-debuginfo", rpm:"nss-util-debuginfo~3.12.5~1.fc12.1", rls:"FC12")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
