# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-5382 (wireshark)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64087);
 script_cve_id("CVE-2009-1210", "CVE-2009-1268", "CVE-2009-1269");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Fedora Core 10 FEDORA-2009-5382 (wireshark)";
 script_name(name);

 desc = "The remote host is missing an update to wireshark
announced via advisory FEDORA-2009-5382.

This package lays base for libpcap, a packet capture and filtering
library, contains command-line utilities, contains plugins and
documentation for wireshark. A graphical user interface is packaged
separately to GTK+ package.

Update Information:

Update to 1.0.8 fixes various security flaws.
http://www.wireshark.org/security/wnpa-sec-2009-03.html
ChangeLog:

* Fri May 22 2009 Radek Vokal  1.0.8-1
- upgrade to 1.0.8
- several security vulnerabilities have been fixed
- CVE-2009-1210 CVE-2009-1268 CVE-2009-1269

References:

[ 1 ] Bug #501929 - Wireshark: PCNFSD dissector crash
https://bugzilla.redhat.com/show_bug.cgi?id=501929

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update wireshark' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-5382

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-5382 (wireshark)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"wireshark", rpm:"wireshark~1.0.8~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-gnome", rpm:"wireshark-gnome~1.0.8~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-debuginfo", rpm:"wireshark-debuginfo~1.0.8~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
