# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-9559 (dovecot)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64861);
 script_cve_id("CVE-2009-2632");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.4");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Fedora Core 10 FEDORA-2009-9559 (dovecot)");

 desc = "The remote host is missing an update to dovecot
announced via advisory FEDORA-2009-9559.

Update Information:

dovecot-sieve updated to 1.1.7
It is derived from CMU sieve used by cyrus-imapd and was affected by
CVE-2009-2632 too.
See upstream announcement for further details:
http://dovecot.org/list/dovecot-news/2009-September/000135.html

ChangeLog:

* Mon Sep 14 2009 Michal Hlavinka  - 1:1.1.18-2
- dovecot-sieve updated to 1.1.7
- fixes bug similar to CVE-2009-2632 (buffer overflow)
* Wed Jul 29 2009 Michal Hlavinka  - 1:1.1.18-1
- updated to 1.1.18
- Maildir++ quota: Quota was sometimes updated wrong when it was
being recalculated.
- Searching quoted-printable message body internally converted _
characters to spaces and didn't match search keys with _.

References:

[ 1 ] Bug #521010 - cyrus-imapd: buffer overflow in cyrus sieve
https://bugzilla.redhat.com/show_bug.cgi?id=521010

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update dovecot' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-9559

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-9559 (dovecot)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"dovecot", rpm:"dovecot~1.1.18~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dovecot-devel", rpm:"dovecot-devel~1.1.18~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dovecot-gssapi", rpm:"dovecot-gssapi~1.1.18~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dovecot-ldap", rpm:"dovecot-ldap~1.1.18~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dovecot-managesieve", rpm:"dovecot-managesieve~1.1.18~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dovecot-mysql", rpm:"dovecot-mysql~1.1.18~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dovecot-pgsql", rpm:"dovecot-pgsql~1.1.18~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dovecot-sieve", rpm:"dovecot-sieve~1.1.18~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dovecot-sqlite", rpm:"dovecot-sqlite~1.1.18~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dovecot-debuginfo", rpm:"dovecot-debuginfo~1.1.18~2.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
