# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:077 (pam)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63648);
 script_cve_id("CVE-2009-0887");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.6");
 script_tag(name:"risk_factor", value:"High");
 name = "Mandrake Security Advisory MDVSA-2009:077 (pam)";
 script_name(name);

 desc = "The remote host is missing an update to pam
announced via advisory MDVSA-2009:077.

A security vulnerability has been identified and fixed in pam:

Integer signedness error in the _pam_StrTok function in
libpam/pam_misc.c in Linux-PAM (aka pam) 1.0.3 and earlier, when a
configuration file contains non-ASCII usernames, might allow remote
attackers to cause a denial of service, and might allow remote
authenticated users to obtain login access with a different user's
non-ASCII username, via a login attempt (CVE-2009-0887).

The updated packages have been patched to prevent this.

Additionally some development packages were missing that are required
to build pam for CS4, these are also provided with this update.

Affected: 2008.0, 2008.1, 2009.0, Corporate 3.0, Corporate 4.0,
          Multi Network Firewall 2.0


Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:077

Risk factor : High";

 script_description(desc);

 summary = "Mandrake Security Advisory MDVSA-2009:077 (pam)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Mandrake Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libpam0", rpm:"libpam0~0.99.8.1~6.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpam-devel", rpm:"libpam-devel~0.99.8.1~6.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam", rpm:"pam~0.99.8.1~6.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam-doc", rpm:"pam-doc~0.99.8.1~6.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64pam0", rpm:"lib64pam0~0.99.8.1~6.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64pam-devel", rpm:"lib64pam-devel~0.99.8.1~6.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpam0", rpm:"libpam0~0.99.8.1~8.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpam-devel", rpm:"libpam-devel~0.99.8.1~8.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam", rpm:"pam~0.99.8.1~8.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam-doc", rpm:"pam-doc~0.99.8.1~8.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64pam0", rpm:"lib64pam0~0.99.8.1~8.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64pam-devel", rpm:"lib64pam-devel~0.99.8.1~8.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpam0", rpm:"libpam0~0.99.8.1~16.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpam-devel", rpm:"libpam-devel~0.99.8.1~16.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam", rpm:"pam~0.99.8.1~16.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam-doc", rpm:"pam-doc~0.99.8.1~16.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64pam0", rpm:"lib64pam0~0.99.8.1~16.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64pam-devel", rpm:"lib64pam-devel~0.99.8.1~16.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpam0", rpm:"libpam0~0.77~12.2.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpam0-devel", rpm:"libpam0-devel~0.77~12.2.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam", rpm:"pam~0.77~12.2.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam-doc", rpm:"pam-doc~0.77~12.2.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64pam0", rpm:"lib64pam0~0.77~12.2.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64pam0-devel", rpm:"lib64pam0-devel~0.77~12.2.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cracklib-dicts", rpm:"cracklib-dicts~2.8.3~1.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcrack2", rpm:"libcrack2~2.8.3~1.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcrack2-devel", rpm:"libcrack2-devel~2.8.3~1.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpam0", rpm:"libpam0~0.77~31.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpam0-devel", rpm:"libpam0-devel~0.77~31.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpwdb0", rpm:"libpwdb0~0.62~2.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpwdb0-devel", rpm:"libpwdb0-devel~0.62~2.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpwdb0-static-devel", rpm:"libpwdb0-static-devel~0.62~2.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam", rpm:"pam~0.77~31.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam-doc", rpm:"pam-doc~0.77~31.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pwdb-conf", rpm:"pwdb-conf~0.62~2.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64crack2", rpm:"lib64crack2~2.8.3~1.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64crack2-devel", rpm:"lib64crack2-devel~2.8.3~1.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64pam0", rpm:"lib64pam0~0.77~31.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64pam0-devel", rpm:"lib64pam0-devel~0.77~31.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64pwdb0", rpm:"lib64pwdb0~0.62~2.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64pwdb0-devel", rpm:"lib64pwdb0-devel~0.62~2.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64pwdb0-static-devel", rpm:"lib64pwdb0-static-devel~0.62~2.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpam0", rpm:"libpam0~0.77~12.2.C30mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpam0-devel", rpm:"libpam0-devel~0.77~12.2.C30mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam", rpm:"pam~0.77~12.2.C30mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam-doc", rpm:"pam-doc~0.77~12.2.C30mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
