###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_alefmentor_detect.nasl 6151 2009-12-16 16:25:36Z dec $
#
# AlefMentor Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901084);
  script_version("$Revision: 7734 $: 1.0");
  script_tag(name:"risk_factor", value:"None");
  script_name("AlefMentor Version Detection");
  desc = "
  Overview: This script finds the running AlefMentor version and saves
  the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("AlefMentor version detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

amPort = get_http_port(default:80);
if(!amPort){
  exit(0);
}

foreach path (make_list("/", "/am", "/AM", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/index.php"), port:amPort);
  rcvRes = http_send_recv(port:amPort, data:sndReq);

  if("AlefMentor" >< rcvRes)
  {
    amVer = eregmatch(pattern:"AlefMentor ([0-9.]+)" , string:rcvRes);
    if(amVer[1] != NULL){
      set_kb_item(name:"www/" + amPort + "/AlefMentor", value:amVer[1] +
                                                      " under " + path);
      security_note(data:"AlefMentor Version " + amVer[1] +
               " running at location " + path +  " was detected on the host");
    }
  }
}
