###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_cyrus_sasllib_mul_bof_vuln.nasl 2347 2009-05-27 15:05:27Z may $
#
# Cyrus SASL Remote Buffer Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900660);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-0688");
  script_bugtraq_id(34961);
  script_name("Cyrus SASL Remote Buffer Overflow Vulnerability");
  desc = "

  Overview: This host has installed Cyrus SASL library and is prone to Remote
  Buffer Overflow vulnerability

  Vulnerability Insight:
  An error in 'sasl_encode64' function within the lib/saslutil.c, as it fails
  to perform adequate boundary checks on user supplied data before copying the
  data to allocated memory buffers.

  Impact:
  Successful exploits allow attackers to run arbitrary code and to crash an
  application that uses the library thus denying service to legitimate users.

  Impact Level: Application

  Affected Software/OS:
  Cyrus SASL version prior to 2.1.23

  Fix:Upgrade to version 2.1.23 or later.
  ftp://ftp.andrew.cmu.edu/pub/cyrus-mail/cyrus-sasl-2.1.23.tar.gz

  References:
  http://secunia.com/advisories/35102
  http://www.kb.cert.org/vuls/id/238019
  http://www.vupen.com/english/advisories/2009/1313

  CVSS Score:
    CVSS Base Score      : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Checks for the Version Cyrus SASL library");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_cyrus_sasllib_detect.nasl");
  script_require_keys("Cyrus/SASL/Ver");
  exit(0);
}


include("version_func.inc");

saslVer = get_kb_item("Cyrus/SASL/Ver");
if(saslVer != NULL)
{
  if(version_is_less(version:saslVer, test_version:"2.1.23")){
  security_hole(0);
  }
}
