##############################################################################
#
#  Microsoft Excel Could Allow Remote Code Execution Vulnerabilities (954066)
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/13
#
#  Revision: 1.1
#
#  Log: schandan
#  Issue #0110
#
#  Make use of version_func_inc - By Chandan S, 11:48:13 2009/04/24
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900028);
 script_bugtraq_id(30638, 30639, 30640, 30641);
 script_cve_id("CVE-2008-3003", "CVE-2008-3004", "CVE-2008-3005", "CVE-2008-3006");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 8288 $");
 script_tag(name:"cvss_base", value:"8.3");
 script_tag(name:"risk_factor", value:"Critical");
 script_category(ACT_GATHER_INFO);
 script_family("Windows : Microsoft Bulletins");
 script_name("Microsoft Excel Could Allow Remote Code Execution Vulnerabilities (954066)");
 script_summary("Check for Microsoft Excel file version");
 desc = "
 MS08-043

 Overview : This host is missing critical security update according to
 Microsoft Bulletin MS08-043.

 Vulnerability Insight :
 Multiple flaw are due to,
 - index values are not properly validated when loading Excel files into memory.
 - an errors during processing/parsing of certain array indexes and record
   values when loading Excel files into memory.
 - a password strings to remote data sources are not being properly deleted even
   when configured to not store credentials.

 Impact : Remote attackers could be able to corrupt memory locations via a
 specially crafted Excel (.xls) files.

 Impact Level : System

 Affected Software/OS :
 Microsoft Excel 2002/XP/2003/2007 on Windows (All).
 Microsoft Excel Viewer 2003/2007 on Windows (All).

 Fix : Run Windows Update and update the listed hotfixes or download and
 update mentioned hotfixes in the advisory from the below link.
 http://www.microsoft.com/technet/security/bulletin/ms08-043.mspx

 References : http://www.microsoft.com/technet/security/bulletin/ms08-043.mspx

 CVSS Score :
   CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
   CVSS Temporal Score : 6.1
 Risk factor : High";
 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl", "secpod_office_products_version_900032.nasl",
		     "secpod_ms_office_detection_900025.nasl");
 script_require_keys("SMB/WindowsVersion", "SMB/Office/Excel/Version");
 script_require_ports(139, 445);
 exit(0);
}


include("version_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(egrep(pattern:"^(9|10|11|12)\..*", string:get_kb_item("MS/Office/Ver")))
{
  excelVer = get_kb_item("SMB/Office/Excel/Version");
  if(!excelVer){
    exit(0);
  }

  if(version_in_range(version:excelVer, test_version:"9.0",
                      test_version2:"9.0.0.8970")){
    security_hole(0);
  }
  else if(version_in_range(version:excelVer, test_version:"10.0",
                           test_version2:"10.0.6844")){
    security_hole(0);
  }
  else if(version_in_range(version:excelVer, test_version:"11.0",
                           test_version2:"11.0.8219")){
    security_hole(0);
  }
  else if(version_in_range(version:excelVer, test_version:"12.0",
                           test_version2:"12.0.6323.4999")){
    security_hole(0);
  }
}
