###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-040.nasl 3931 2009-08-12 11:17:38Z aug $
#
# Microsoft Windows Message Queuing Privilege Escalation Vulnerability (971032)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900908);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1922");
  script_bugtraq_id(35969);
  script_name("Microsoft Windows Message Queuing Privilege Escalation Vulnerability (971032)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-040.

  Vulnerability Insight:
  An error occurs while parsing malicious IOCTL requests sent to the Message Queuing
  service (MSMQ) because the input data is not adequately sanitised before being
  passed into the buffer.

  Impact:
  Successful exploitation will allow attackers to execute arbitrary code with
  SYSTEM level privileges and completely compromise the affected system.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2K Service Pack 4 and prior.
  Microsoft Windows XP Service Pack 2 and prior.
  Microsoft Windows 2003 Service Pack 2 and prior.

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/Bulletin/MS09-040.mspx

  References:
  http://secunia.com/advisories/36214/
  http://support.microsoft.com/kb/971032
  http://www.microsoft.com/technet/security/Bulletin/MS09-040.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the vulnerable file version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

# MS09-040 Hotfix (971032)
if(hotfix_missing(name:"971032") == 0){
  exit(0);
}

exePath = registry_get_sz(item:"Install Path",
                          key:"SOFTWARE\Microsoft\COM3\Setup");
if(!exePath){
  exit(0);
}
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exePath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:exePath +
                                                            "\Mqsvc.exe");
exeVer = GetVer(file:file, share:share);
if(!exeVer){
  exit(0);
}

if(hotfix_check_sp(win2k:5) > 0)
{
  # Check for Mqsvc.exe version 5.0 < 5.0.0.808
  if(version_in_range(version:exeVer, test_version:"5.0",
                      test_version2:"5.0.0.807")){
    security_hole(0);
  }
  exit(0);
}
else if(hotfix_check_sp(xp:3) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for Mqsvc.exe version 5.1 < 5.1.0.1111
    if(version_in_range(version:exeVer, test_version:"5.1",
                        test_version2:"5.1.0.1110")){
      security_hole(0);
    }
    exit(0);
  }
}
else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for Mqsvc.exe version 5.2 < 5.2.2007.4530
    if(version_in_range(version:exeVer, test_version:"5.2",
                        test_version2:"5.2.2007.4529")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
