###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_novell_net_idnty_code_exec_vuln.nasl 1874 2009-04-23 11:58:18Z apr $
#
# Novell NetIdentity Agent Pointer Dereference Remote Code Execution Vulnerability
#
# Authors:
# Sharaths S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900341);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1350");
  script_bugtraq_id(34400);
  script_name("Novell NetIdentity Agent Pointer Dereference Remote Code Execution Vulnerability");
  desc = "

  Overview: The host is installed with Novell NetIdentity Agent and is prone
  to remote code execution vulnerability.

  Vulnerability Insight:
  Handling of RPC messages over the XTIERRPCPIPE named pipe in 'xtagent.exe',
  and sending RPC messages that triggers the dereference of an arbitrary
  pointer which can cause remote code execution.

  Impact:
  Successful exploitation will let the attacker execute arbitrary code in the
  context of the affected application with system privileges through a valid
  IPC$ connection.

  Impact Level: System

  Affected Software/OS:
  Novell NetIdentity Agent version prior to 1.2.4 on Windows.

  Fix: Upgrade to NetIdentity Client version 1.2.4
  http://download.novell.com/Download?buildid=6ERQGPjRZ8o~

  References:
  http://www.vupen.com/english/advisories/2009/0954
  http://www.zerodayinitiative.com/advisories/ZDI-09-016
  http://securitytracker.com/alerts/2009/Apr/1021990.html
  http://www.securityfocus.com/archive/1/archive/1/502514/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Novell NetIdentity Agent");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_novell_prdts_detect_win.nasl");
  script_require_keys("Novell/NetIdentity/Ver");
  exit(0);
}


include("version_func.inc");

netidVer = get_kb_item("Novell/NetIdentity/Ver");
if(!netidVer){
  exit(0);
}

# Check for Novell NetIdentity version prior to 1.2.4
if(version_is_less(version:netidVer, test_version:"1.2.4")){
  security_hole(0);
}
