###############################################################################
# OpenVAS Vulnerability Test
# $Id: znc_detect.nasl 7592 2010-05-07 14:44:11Z chandra $
#
# ZNC Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.

desc = "

Overview:
This host is running ZNC, an IRC Bouncer.

See also:
http://en.znc.in/wiki/ZNC

Risk factor : None";

if (description)
{
 script_id(100243);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"None");

 script_name("ZNC Detection");
 script_description(desc);
 script_summary("Checks for the presence of ZNC");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "find_service2.nasl","http_version.nasl");
 script_require_ports("Services/irc", 6667);
 exit(0);
}

include("global_settings.inc");
include("ssl_funcs.inc");
include("http_func.inc");
include("misc_func.inc");

port = get_kb_item("Services/irc");
if (!port) port = 6667;
if(! get_port_state(port)) exit(0);

if(cert = get_server_cert(port)) {
  transport = ENCAPS_SSLv23;
} else {
  transport = ENCAPS_IP;
}  

soc = open_sock_tcp(port,transport:transport);
if (! soc) exit(0);

req=string("USER\r\n");
send(socket: soc, data: req);

buf = recv_line(socket:soc, length:64);
close(soc);

 if(egrep(pattern:"irc\.znc\.in NOTICE AUTH" , string: buf, icase: TRUE)) {
       
       set_kb_item(name:"Services/irc/" + port + "/znc", value:TRUE);
       kb_transport = get_port_transport(port);
       
       if(kb_transport < transport) {
	 replace_kb_item(name: string("Transports/TCP/",port), value: transport);
       }
      
       if(banner = get_http_banner(port:port)) { # only way to get version is from webadmin-module (if enabled). 

          version = eregmatch(string: banner, pattern: "Server: ZNC ([0-9.]+)",icase:TRUE);

	  if ( !isnull(version[1]) ) {
            vers=version[1];
            set_kb_item(name: string("znc/", port, "/version"), value: vers);
       
            info = string("None\n\nZNC Version '");
            info += string(vers);
            info += string("' was detected on the remote host\n");

            desc = ereg_replace(
                string:desc,
                pattern:"None$",
                replace:info
            );
        }	
       }
	 
       if(report_verbosity > 0) {
         security_note(port:port,data:desc);
       }
       exit(0);
 }

exit(0);

