(gallery)=
# Gallery

The following page contains a collection of practical examples and problems solved with **poliastro**. From interplanetary transfers, to asteroid-catching missions or even propagation under external perturbations.
In addition, the user might come across tutorials related on how to use and customize
the plotting utilities, insight on the {ref}`API <api-reference>` capabilities and many other topics related to orbital mechanics.

```{eval-rst}
.. nbgallery::

   /examples/Analyzing the Parker Solar Probe flybys.mystnb
   /examples/Atmospheric models.mystnb
   /examples/Catch that asteroid!.mystnb
   /examples/Customising static orbit plots.mystnb
   /examples/CZML Tutorial.mystnb
   /examples/Exploring the New Horizons launch.mystnb
   /examples/Going to Mars with Python using poliastro.mystnb
   /examples/Going to Jupiter with Python using Jupyter and poliastro.mystnb
   /examples/Generating orbit groundtracks.mystnb
   /examples/Plotting in 3D.mystnb
   /examples/Analyzing NEOs.mystnb
   /examples/Visualizing the SpaceX Tesla Roadster trip to Mars.mystnb
   /examples/Natural and artificial perturbations.mystnb
   /examples/Porkchops with poliastro.mystnb
   /examples/Tisserand.mystnb
   /examples/Detecting Events.mystnb
   /examples/Loading OMM and TLE satellite data.mystnb
   
```
