/*
 * Copyright 2013 Canonical Ltd.
 *
 * This file is part of powerd.
 *
 * powerd is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * powerd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include "powerd-internal.h"

#include "libsuspend.h"
#include "powerd-dbus.h"

#include <unordered_set>

static std::unordered_set<std::string> active_proximity_users;
gboolean handle_enable_proximity_handling(PowerdSource *obj,
                                          GDBusMethodInvocation *invocation,
                                          const char *name)
{
    if (active_proximity_users.empty())
        powerd_sensors_proximity_enable();
    else
        powerd_sensors_proximity_emit();

    active_proximity_users.insert(name);

    g_dbus_method_invocation_return_value(invocation, NULL);

    return TRUE;
}


gboolean handle_disable_proximity_handling(PowerdSource *obj,
                                           GDBusMethodInvocation *invocation,
                                           const char *name)
{
    bool was_empty = active_proximity_users.empty();
    active_proximity_users.erase(name);
    if (!was_empty && active_proximity_users.empty())
        powerd_sensors_proximity_disable();

    g_dbus_method_invocation_return_value(invocation, NULL);

    return TRUE;
}

void powerd_proximity_event(gboolean near)
{
    if (near)
        turn_display_on(FALSE, UNITY_SCREEN_REASON_PROXIMITY);
    else
        turn_display_on(TRUE, UNITY_SCREEN_REASON_PROXIMITY);
}

