"""
Searchable Combobox for Contact Display Names
"""
#  Copyright (C) 2004  Henning Jacobs <henning@srcco.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  $Id: ContactSelectboxWidget.py 142 2005-09-13 21:16:23Z henning $

import InputWidgets
import ToolTip
import broadcaster

class ContactSelectboxWidget(InputWidgets.SearchableCombobox):
    def __init__(self, master, model, command, **kws):
        kws.setdefault('label_text', "Search/Select:")
        InputWidgets.SearchableCombobox.__init__(self, master,
                                                 command, label_text=kws['label_text'])
        ToolTip.ToolTip(self, "enter the first characters from family name\n"+\
                              "or select a contact from the list\n"+\
                              "(you can also use the UP and DOWN keys)")
        self.model = model
        self.registerAtBroadcaster()
        
    def registerAtBroadcaster(self):
        "Register our Widget's Callback Handlers"
        broadcaster.Register(self.updateList,
            source='Contacts', title='Opened')
        broadcaster.Register(self.updateList,
            source='Contacts', title='Closed')
        # Import hook not needed because New and Save will do the job:    
        #broadcaster.Register(self.updateList,
        #    source='Contacts', title='Imported')
        broadcaster.Register(self.onContactSave,
            source='Contact', title='Saved')
        broadcaster.Register(self.onContactNew,
            source='Contact', title='Added')
        broadcaster.Register(self.onContactDel,
            source='Contact', title='Deleted')
    
    def getUpdatedContactData(self):
        handle = broadcaster.CurrentData()['handle']
        if broadcaster.CurrentTitle() != "Deleted":
            attrlist = self.model.QueryAttributes([handle], 'DisplayName')
            return (handle, attrlist[0]) 
        else:
            return (handle, None)
    
    def onContactNew(self):
        handle, attr = self.getUpdatedContactData()
        self._contacthandles.insert(0, handle)
        self._contactdispnames.insert(0, attr)
        self.setlist(zip(self._contactdispnames, self._contacthandles))
        self.set(attr, "do_not_execute")

    def onContactDel(self):
        handle, attr = self.getUpdatedContactData() 
        idx = self._contacthandles.index(handle)
        del self._contacthandles[idx]
        del self._contactdispnames[idx]
        self.setlist(zip(self._contactdispnames, self._contacthandles))
        self.set("", "do_not_execute")

    def onContactSave(self):
        handle, attr = self.getUpdatedContactData() 
        idx = self._contacthandles.index(handle)
        self._contactdispnames[idx] = attr
        self.setlist(zip(self._contactdispnames, self._contacthandles))
        self.set(self._contactdispnames[idx], "do_not_execute")

    _contacthandles = []
    _contactdispnames = []
    def updateList(self):
        "completely update our list"
        self._contacthandles[:] = self.model.ListHandles()
        self._contactdispnames = self.model.QueryAttributes(self._contacthandles, 'DisplayName')
        self.setlist(zip(self._contactdispnames, self._contacthandles))

    def selectContact(self, handle):
        self.set(self._contactdispnames[self._contacthandles.index(handle)],
                 "do_not_execute")

