#  Copyright (C) 2004  Henning Jacobs <henning@srcco.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  $Id: broker.py 82 2004-07-11 13:01:44Z henning $

__all__ = ['Register', 'UnRegister', 'Request', 'CurrentTitle', 'CurrentData']

import debug

providers = {}
currentTitles = []
currentData= []

def Register(title, provider, arguments=()):
    assert not providers.has_key(title)
    providers[title] = (provider, arguments)
        
def UnRegister(title):
    try:
        del providers[title]
    except:
        debug.echo("broker.UnRegister(): failed to unregister provider for '%s'" % title)

def Request(title, data={}):
    currentTitles.append(title)
    currentData.append(data)

    result = apply(apply, providers.get(title))
    
    currentTitles.pop()
    currentData.pop()

    return result

def CurrentTitle():
    return currentTitles[-1]

def CurrentData():
    return currentData[-1]
