'''OpenGL extension GREMEDY.frame_terminator

This module customises the behaviour of the 
OpenGL.raw.GL.GREMEDY.frame_terminator to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension defines a mechanism that enables marking the end 
	of render frames within the OpenGL stream.
	
	When debugging or profiling an OpenGL application, the debuggers
	and profilers needs to know when a render frame is ended. This
	is important for frame per second measurements, statistical analysis, 
	marking and clearing stream loggers logs, performance counters 
	sampling and more.
	
	When an application uses off screen buffers, the debugger / profiler
	cannot be guaranteed that the application will call a certain function at
	the end of each off-screen frame (e.g: SwapBuffers / glClear / etc). 
	This extension enables the application to notify the debugger / profiler 
	whenever a render frame is ended.
	
	This extension is mainly useful for debuggers and profilers. It is not 
	expected that standard drivers would implement this extension. The main
	point of having this extension is to allow applications to have a clean 
	way of accessing this functionality only when they are run under the 
	control of a debugger / profiler, without having to recompile or change 
	the application source code.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/GREMEDY/frame_terminator.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.GREMEDY.frame_terminator import *
from OpenGL.raw.GL.GREMEDY.frame_terminator import _EXTENSION_NAME

def glInitFrameTerminatorGREMEDY():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION