'''OpenGL extension SGIX.visual_select_group

This module customises the behaviour of the 
OpenGL.raw.GLX.SGIX.visual_select_group to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides a mechanism to lower visual selection 
	priorities that glXChooseVisual or glXChooseFBConfig defines.  
	A new visual attribute is introduced, providing a way for servers
	to group visuals to different visual selection categories.
	The visual selection priorities of all the visuals in one category
	may be higher or lower than the ones in another category.  
	The visual selection priorities in one category follow the rules
	of glXChooseVisual or glXChooseFBConfig.  The new attribute is 
	invisible to users so can't be queried by glXGetConfig or 
	glXGetFBConfigAttrib.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/SGIX/visual_select_group.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLX import _types, _glgets
from OpenGL.raw.GLX.SGIX.visual_select_group import *
from OpenGL.raw.GLX.SGIX.visual_select_group import _EXTENSION_NAME

def glInitVisualSelectGroupSGIX():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION