'''OpenGL extension ARB.texture_rgb10_a2ui

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.texture_rgb10_a2ui to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds support for the following data format:
	
	A new texturing format for unsigned 10.10.10.2 integer textures. 
	
	OpenGL has supported RGB10 and RGB10_A2 formats for a very long time.  
	This extension provides a variant of RGB10_A2 which supports unsigned 
	integer data (in contrast to the above "unsigned normalized integer" 
	formats).

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/texture_rgb10_a2ui.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.ARB.texture_rgb10_a2ui import *
from OpenGL.raw.GL.ARB.texture_rgb10_a2ui import _EXTENSION_NAME

def glInitTextureRgb10A2UiARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION