# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class UserFragment(Resource):
    """Profile of a lab user.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict
    :param identity: The identity of the user.
    :type identity: :class:`UserIdentityFragment
     <azure.mgmt.devtestlabs.models.UserIdentityFragment>`
    :param secret_store: The secret store of the user.
    :type secret_store: :class:`UserSecretStoreFragment
     <azure.mgmt.devtestlabs.models.UserSecretStoreFragment>`
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :type unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'properties.identity', 'type': 'UserIdentityFragment'},
        'secret_store': {'key': 'properties.secretStore', 'type': 'UserSecretStoreFragment'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, location=None, tags=None, identity=None, secret_store=None, provisioning_state=None, unique_identifier=None):
        super(UserFragment, self).__init__(location=location, tags=tags)
        self.identity = identity
        self.secret_store = secret_store
        self.provisioning_state = provisioning_state
        self.unique_identifier = unique_identifier
