# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, AsyncIterable, Callable, Dict, Generic, Optional, TypeVar, Union
import warnings

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse, HttpRequest

from ... import models as _models

T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class ConfidentialLedgerOperations:
    """ConfidentialLedgerOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    async def get_constitution(
        self,
        **kwargs
    ) -> "_models.Constitution":
        """Gets the constitution used for governance.

        The constitution is a script that assesses and applies proposals from consortium members.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Constitution, or the result of cls(response)
        :rtype: ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.Constitution
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.Constitution"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "0.1-preview"
        accept = "application/json"

        # Construct URL
        url = self.get_constitution.metadata['url']  # type: ignore
        path_format_arguments = {
            'ledgerUri': self._serialize.url("self._config.ledger_uri", self._config.ledger_uri, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('Constitution', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_constitution.metadata = {'url': '/app/governance/constitution'}  # type: ignore

    async def get_consortium_members(
        self,
        **kwargs
    ) -> "_models.Consortium":
        """Gets the consortium members.

        Consortium members can manage the Confidential Ledger.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Consortium, or the result of cls(response)
        :rtype: ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.Consortium
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.Consortium"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "0.1-preview"
        accept = "application/json"

        # Construct URL
        url = self.get_consortium_members.metadata['url']  # type: ignore
        path_format_arguments = {
            'ledgerUri': self._serialize.url("self._config.ledger_uri", self._config.ledger_uri, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('Consortium', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_consortium_members.metadata = {'url': '/app/governance/members'}  # type: ignore

    async def get_enclave_quotes(
        self,
        **kwargs
    ) -> "_models.ConfidentialLedgerEnclaves":
        """Gets quotes for all nodes of the Confidential Ledger.

        A quote is an SGX enclave measurement that can be used to verify the validity of a node and its
        enclave.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ConfidentialLedgerEnclaves, or the result of cls(response)
        :rtype: ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.ConfidentialLedgerEnclaves
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ConfidentialLedgerEnclaves"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "0.1-preview"
        accept = "application/json"

        # Construct URL
        url = self.get_enclave_quotes.metadata['url']  # type: ignore
        path_format_arguments = {
            'ledgerUri': self._serialize.url("self._config.ledger_uri", self._config.ledger_uri, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('ConfidentialLedgerEnclaves', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_enclave_quotes.metadata = {'url': '/app/enclaveQuotes'}  # type: ignore

    def get_ledger_entries(
        self,
        sub_ledger_id: Optional[str] = None,
        from_transaction_id: Optional[str] = None,
        to_transaction_id: Optional[str] = None,
        **kwargs
    ) -> AsyncIterable["_models.PagedLedgerEntries"]:
        """Gets ledger entries from a sub-ledger corresponding to a range.

        A sub-ledger id may optionally be specified. Only entries in the specified (or default)
        sub-ledger will be returned.

        :param sub_ledger_id: The sub-ledger id.
        :type sub_ledger_id: str
        :param from_transaction_id: Specify the first transaction ID in a range.
        :type from_transaction_id: str
        :param to_transaction_id: Specify the last transaction ID in a range.
        :type to_transaction_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PagedLedgerEntries or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.PagedLedgerEntries]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PagedLedgerEntries"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "0.1-preview"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.get_ledger_entries.metadata['url']  # type: ignore
                path_format_arguments = {
                    'ledgerUri': self._serialize.url("self._config.ledger_uri", self._config.ledger_uri, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if sub_ledger_id is not None:
                    query_parameters['subLedgerId'] = self._serialize.query("sub_ledger_id", sub_ledger_id, 'str')
                if from_transaction_id is not None:
                    query_parameters['fromTransactionId'] = self._serialize.query("from_transaction_id", from_transaction_id, 'str')
                if to_transaction_id is not None:
                    query_parameters['toTransactionId'] = self._serialize.query("to_transaction_id", to_transaction_id, 'str')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'ledgerUri': self._serialize.url("self._config.ledger_uri", self._config.ledger_uri, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize('PagedLedgerEntries', pipeline_response)
            list_of_elem = deserialized.entries
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize.failsafe_deserialize(_models.ConfidentialLedgerError, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(
            get_next, extract_data
        )
    get_ledger_entries.metadata = {'url': '/app/transactions'}  # type: ignore

    async def post_ledger_entry(
        self,
        contents: str,
        sub_ledger_id: Optional[str] = None,
        **kwargs
    ) -> "_models.LedgerWriteResult":
        """Writes a ledger entry.

        A sub-ledger id may optionally be specified.

        :param contents: Contents of the ledger entry.
        :type contents: str
        :param sub_ledger_id: The sub-ledger id.
        :type sub_ledger_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LedgerWriteResult, or the result of cls(response)
        :rtype: ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.LedgerWriteResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.LedgerWriteResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        _entry = _models.LedgerEntry(contents=contents)
        api_version = "0.1-preview"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.post_ledger_entry.metadata['url']  # type: ignore
        path_format_arguments = {
            'ledgerUri': self._serialize.url("self._config.ledger_uri", self._config.ledger_uri, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if sub_ledger_id is not None:
            query_parameters['subLedgerId'] = self._serialize.query("sub_ledger_id", sub_ledger_id, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if _entry is not None:
            body_content = self._serialize.body(_entry, 'LedgerEntry')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-ccf-transaction-id']=self._deserialize('str', response.headers.get('x-ms-ccf-transaction-id'))
        deserialized = self._deserialize('LedgerWriteResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    post_ledger_entry.metadata = {'url': '/app/transactions'}  # type: ignore

    async def get_ledger_entry(
        self,
        transaction_id: str,
        sub_ledger_id: Optional[str] = None,
        **kwargs
    ) -> "_models.LedgerQueryResult":
        """Gets the ledger entry at the specified transaction id. A sub-ledger id may optionally be specified to indicate the sub-ledger from which to fetch the value.

        To return older ledger entries, the relevant sections of the ledger must be read from disk and
        validated. To prevent blocking within the enclave, the response will indicate whether the entry
        is ready and part of the response, or if the loading is still ongoing.

        :param transaction_id: Identifies a write transaction.
        :type transaction_id: str
        :param sub_ledger_id: The sub-ledger id.
        :type sub_ledger_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LedgerQueryResult, or the result of cls(response)
        :rtype: ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.LedgerQueryResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.LedgerQueryResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "0.1-preview"
        accept = "application/json"

        # Construct URL
        url = self.get_ledger_entry.metadata['url']  # type: ignore
        path_format_arguments = {
            'ledgerUri': self._serialize.url("self._config.ledger_uri", self._config.ledger_uri, 'str', skip_quote=True),
            'transactionId': self._serialize.url("transaction_id", transaction_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if sub_ledger_id is not None:
            query_parameters['subLedgerId'] = self._serialize.query("sub_ledger_id", sub_ledger_id, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('LedgerQueryResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_ledger_entry.metadata = {'url': '/app/transactions/{transactionId}'}  # type: ignore

    async def get_receipt(
        self,
        transaction_id: str,
        **kwargs
    ) -> "_models.TransactionReceipt":
        """Gets a receipt certifying ledger contents at a particular transaction id.

        Gets a receipt certifying ledger contents at a particular transaction id.

        :param transaction_id: Identifies a write transaction.
        :type transaction_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TransactionReceipt, or the result of cls(response)
        :rtype: ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.TransactionReceipt
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.TransactionReceipt"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "0.1-preview"
        accept = "application/json"

        # Construct URL
        url = self.get_receipt.metadata['url']  # type: ignore
        path_format_arguments = {
            'ledgerUri': self._serialize.url("self._config.ledger_uri", self._config.ledger_uri, 'str', skip_quote=True),
            'transactionId': self._serialize.url("transaction_id", transaction_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('TransactionReceipt', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_receipt.metadata = {'url': '/app/transactions/{transactionId}/receipt'}  # type: ignore

    async def get_transaction_status(
        self,
        transaction_id: str,
        **kwargs
    ) -> "_models.TransactionStatus":
        """Gets the status of an entry identified by a transaction id.

        Gets the status of an entry identified by a transaction id.

        :param transaction_id: Identifies a write transaction.
        :type transaction_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TransactionStatus, or the result of cls(response)
        :rtype: ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.TransactionStatus
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.TransactionStatus"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "0.1-preview"
        accept = "application/json"

        # Construct URL
        url = self.get_transaction_status.metadata['url']  # type: ignore
        path_format_arguments = {
            'ledgerUri': self._serialize.url("self._config.ledger_uri", self._config.ledger_uri, 'str', skip_quote=True),
            'transactionId': self._serialize.url("transaction_id", transaction_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('TransactionStatus', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_transaction_status.metadata = {'url': '/app/transactions/{transactionId}/status'}  # type: ignore

    async def get_current_ledger_entry(
        self,
        sub_ledger_id: Optional[str] = None,
        **kwargs
    ) -> "_models.LedgerEntry":
        """Gets the current value available in the ledger.

        A sub-ledger id may optionally be specified.

        :param sub_ledger_id: The sub-ledger id.
        :type sub_ledger_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LedgerEntry, or the result of cls(response)
        :rtype: ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.LedgerEntry
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.LedgerEntry"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "0.1-preview"
        accept = "application/json"

        # Construct URL
        url = self.get_current_ledger_entry.metadata['url']  # type: ignore
        path_format_arguments = {
            'ledgerUri': self._serialize.url("self._config.ledger_uri", self._config.ledger_uri, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if sub_ledger_id is not None:
            query_parameters['subLedgerId'] = self._serialize.query("sub_ledger_id", sub_ledger_id, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('LedgerEntry', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_current_ledger_entry.metadata = {'url': '/app/transactions/current'}  # type: ignore

    async def delete_user(
        self,
        user_id: str,
        **kwargs
    ) -> None:
        """Deletes a user from the Confidential Ledger.

        Deletes a user from the Confidential Ledger.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint.
        :type user_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "0.1-preview"
        accept = "application/json"

        # Construct URL
        url = self.delete_user.metadata['url']  # type: ignore
        path_format_arguments = {
            'ledgerUri': self._serialize.url("self._config.ledger_uri", self._config.ledger_uri, 'str', skip_quote=True),
            'userId': self._serialize.url("user_id", user_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_user.metadata = {'url': '/app/users/{userId}'}  # type: ignore

    async def get_user(
        self,
        user_id: str,
        **kwargs
    ) -> "_models.LedgerUser":
        """Gets a user.

        Gets a user.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint.
        :type user_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LedgerUser, or the result of cls(response)
        :rtype: ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.LedgerUser
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.LedgerUser"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "0.1-preview"
        accept = "application/json"

        # Construct URL
        url = self.get_user.metadata['url']  # type: ignore
        path_format_arguments = {
            'ledgerUri': self._serialize.url("self._config.ledger_uri", self._config.ledger_uri, 'str', skip_quote=True),
            'userId': self._serialize.url("user_id", user_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('LedgerUser', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_user.metadata = {'url': '/app/users/{userId}'}  # type: ignore

    async def create_or_update_user(
        self,
        user_id: str,
        assigned_role: Union[str, "_models.ConfidentialLedgerUserRoleName"],
        **kwargs
    ) -> "_models.LedgerUser":
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint.
        :type user_id: str
        :param assigned_role: Represents an assignable role.
        :type assigned_role: str or ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.ConfidentialLedgerUserRoleName
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LedgerUser, or the result of cls(response)
        :rtype: ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.LedgerUser
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.LedgerUser"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        _user_details = _models.LedgerUser(assigned_role=assigned_role)
        api_version = "0.1-preview"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.create_or_update_user.metadata['url']  # type: ignore
        path_format_arguments = {
            'ledgerUri': self._serialize.url("self._config.ledger_uri", self._config.ledger_uri, 'str', skip_quote=True),
            'userId': self._serialize.url("user_id", user_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(_user_details, 'LedgerUser')
        body_content_kwargs['content'] = body_content
        request = self._client.patch(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('LedgerUser', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_or_update_user.metadata = {'url': '/app/users/{userId}'}  # type: ignore
