//
// C++ Interface: qtscriptPrg
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//

/**
	@author Harald Krippel <harald@the-develop.net>
*/

#ifndef QTSCRIPT_PRG_H
#define QTSCRIPT_PRG_H

#include <QtScript>

#include "scripting.hpp"
#include "scriptprg.hpp"

#ifdef USE_SCRIPT_DEBUGGER
#include <QScriptEngineDebugger>
#endif

class qtscriptPrg : public scriptPrg
{
public:
    qtscriptPrg(const QString & program , const int thisid);
    ~qtscriptPrg();
    int compile(void);
    int run(void);
    void update(void);

protected:
  int runFile(const QString &prgfile, const QString &name, bool debug);
  QScriptEngine engine;
#ifdef USE_SCRIPT_DEBUGGER
  QScriptEngineDebugger debugger;
#endif
  QcakeScriptApi *ScriptApi;
  QString  prgname;
};

#endif
