# Kvantum

## Overview

Kvantum (by [Pedram Pourang, a.k.a. Tsu Jan](#contact)) is an SVG-based theme engine for Qt, tuned to KDE and LXQt, with an emphasis on elegance, usability and practicality. Its homepage is <https://github.com/tsujan/Kvantum>.

Kvantum has a default dark theme, which is inspired by the default theme of Enlightenment. Creation of realistic themes like that for KDE was my first reason to make Kvantum but it goes far beyond its default theme: you could make themes with very different looks and feels for it, whether they be photorealistic or cartoonish, 3D or flat, embellished or minimalistic, or something in between, and Kvantum will let you control almost every aspect of Qt widgets.

Kvantum also comes with many other themes that are installed as root and can be selected and activated by using Kvantum Manager.

## Installation and usage

See [INSTALL](INSTALL.md) for instructions on how to compile, install and use Kvantum.

### Configuring themes

See [Theme-Config](doc/Theme-Config) for instructions on how to install and configure themes.

### Theme making

See [Theme-Making](doc/Theme-Making.pdf) for instructions on how to create themes.

## Contact

You can contact me at <tsujan2000@gmail.com>.

## Credits:

The core idea of Kvantum, namely using of SVG images for drawing Qt widgets, was taken from QuantumStyle (not developed anymore but continued as [QSvgStyle](https://github.com/DexterMagnific/QSvgStyle)).

Some code parts are adapted from [QtCurve](https://projects.kde.org/projects/playground/artwork/qtcurve/repository), [Oxygen](https://projects.kde.org/projects/playground/artwork/oxygen/repository), [Oxygen-Transparent](https://projects.kde.org/projects/playground/artwork/oxygen-transparent/repository) and [Bespin](http://cloudcity.sourceforge.net/download.php).

[TheMainOne](https://github.com/TheEvilSkeleton) kindly improved the current file (README) as well as [INSTALL](INSTALL.md).

My sincerest thanks go to all users whose bug reports, feature requests and suggestions have been crucial for improving Kvantum.

## Some Screenshots:

![Default](screenshots/Default.png?raw=true "Default")
![KvAmbience](screenshots/KvAmbience.png?raw=true "KvAmbience")
![KvBeige](screenshots/KvBeige.png?raw=true "KvBeige")
![KvGray](screenshots/KvGray.png?raw=true "KvGray")
![KvMojave](screenshots/KvMojave.png?raw=true "KvMojave")
![KvMojaveLight](screenshots/KvMojaveLight.png?raw=true "KvMojaveLight")
![KvCurves3d](screenshots/KvCurves3d.png?raw=true "KvCurves3d")
![KvCurvesLight1](screenshots/KvCurvesLight1.png?raw=true "KvCurvesLight1")
![KvGnomish](screenshots/KvGnomish.png?raw=true "KvGnomish")
![KvOxygen](screenshots/KvOxygen.png?raw=true "KvOxygen")
![KvSimplicityDark](screenshots/KvSimplicityDark.png?raw=true "KvSimplicityDark")
![KvSimplicityTurquoise](screenshots/KvSimplicityTurquoise.png?raw=true "KvSimplicityTurquoise")
![KvFlatLight](screenshots/KvFlatLight.png?raw=true "KvFlatLight")
