/***************************************************************************
 *   Copyright (C) 2007-2014 by Vegeta                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CORE_H
#define CORE_H
#include <QString>
#include <QDateTime>


enum GUI_STATUS {BUSY = 0, IDLE, RESET_ALL};

class Core{

private:
    bool m_isTrackGain, m_isShowBrowser, m_isCancel, m_isMP3Gain_found, m_isMP4Gain_found, m_isVorbisGain_found,
    m_isFlacGain_found, m_isLogSkippedFiles, m_isid3v2_found, m_isAutorenameFiles, m_isAutorenameFolder, m_isDownloadCovers,
    m_isDragDropAllowed, m_isReplayGain, m_isAutoExit;

    int m_finishedFiles, m_Errors, m_skippedFiles, m_Volume, m_filesProcessed, m_filesGained, m_SearchEngine;

    QString m_MP3GainBinaryPath, m_VorbisGainBinaryPath, m_FlacGainBinaryPath, m_MP4GainBinaryPath, m_isid3v2Path,
    m_TemplateFolderRename, m_TemplateFileRename, m_Filename;

    QDateTime m_Now;

    QDate m_installDate;


public:
    Core();
    ~Core();

    QList<QString> allFiles;
    QString FilenameWithoutPath(const int &Nummer);
    QString TimeUpdateString();

    void resetVariables();
    void setStartTime(){m_Now = QDateTime::currentDateTime();}

    void addFinishedFiles() {
        ++m_finishedFiles;
        ++m_filesProcessed;
        ++m_filesGained;
    }
    int  finishedFiles() const {return m_finishedFiles;}

    void addSkippedFiles() {
        ++m_skippedFiles;
        --m_filesGained;
    }
    int  skippedFiles() const {return m_skippedFiles;}

    void addErrors() {
        ++m_Errors;
        --m_filesGained;
    }
    int  Errors() const {return m_Errors;}

    void setVolume(const int &val) {m_Volume = val;}
    int  Volume() const {return m_Volume;}

    void setTrackGain(const bool &val) {m_isTrackGain = val;}
    bool isTrackGain() const {return m_isTrackGain;}

    void setShowBrowserAtStatup(const bool &val) {m_isShowBrowser = val;}
    bool isShowBrowserAtStatup() const {return m_isShowBrowser;}

    void setOperationCanceled(const bool &val) {m_isCancel = val;}
    bool isOperationCanceled() const {return m_isCancel;}

    bool isLogSkippedFiles() const {return m_isLogSkippedFiles;}
    void setIsLogSkippedFiles(const bool &val) {m_isLogSkippedFiles = val;}

    void setCurrentFileName(const QString &val) {m_Filename = val;}
    QString currentFileName() const {return m_Filename;}

    bool isMP3GainFound() const {return m_isMP3Gain_found;}
    void setIsMP3GainFound(const bool &val) {m_isMP3Gain_found = val;}

    bool isMP4GainFound() const {return m_isMP4Gain_found;}
    void setIsMP4GainFound(const bool &val) {m_isMP4Gain_found = val;}

    bool isVorbisGainFound() const {return m_isVorbisGain_found;}
    void setIsVorbisGainFound(const bool &val) {m_isVorbisGain_found = val;}

    bool isFlacGainFound() const {return m_isFlacGain_found;}
    void setIsFlacGainFound(const bool &val) {m_isFlacGain_found = val;}

    QString MP3GainBinaryPath() const {return m_MP3GainBinaryPath;}
    void setMP3GainBinaryPath(const QString &Pfad){m_MP3GainBinaryPath = Pfad;}

    QString MP4GainBinaryPath() const {return m_MP4GainBinaryPath;}
    void setMP4GainBinaryPath(const QString &Pfad){m_MP4GainBinaryPath = Pfad;}

    QString VorbisGainBinaryPath() const {return m_VorbisGainBinaryPath;}
    void setVorbisGainBinaryPath(const QString &Pfad){m_VorbisGainBinaryPath = Pfad;}

    QString FlacGainBinaryPath() const {return m_FlacGainBinaryPath;}
    void setFlacGainBinaryPath(const QString &Pfad){m_FlacGainBinaryPath = Pfad;}

    bool isAutoExit() const {return m_isAutoExit;}
    void setIsAutoExit(const bool val){m_isAutoExit = val;}

    void Statistic(int &filesProcessed, int &filesGained, QDate &installDate) {
        filesProcessed = m_filesProcessed;
        filesGained    = m_filesGained;
        installDate    = m_installDate;
    }

    void setStatistic(const int &filesProcessed, const int &filesGained, const QDate installDate) {
        m_filesProcessed = filesProcessed;
        m_filesGained    = filesGained;
        m_installDate    = installDate;
    }


    void setSearchEngine(int val){m_SearchEngine = val;}
    int searchEngine() const {return m_SearchEngine;}

    void setIsDragDropAllowed(bool val){m_isDragDropAllowed = val;}
    bool isDragDropAllowed() const {return m_isDragDropAllowed;}
};

#endif // CORE_H
