/*
 * Copyright 2013 Canonical Ltd.
 *
 * This file is part of qtorganizer5-eds.
 *
 * contact-service-app is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * contact-service-app is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __QORGANIZER_EDS_SAVECOLLECTIONREQUESTDATA_H__
#define __QORGANIZER_EDS_SAVECOLLECTIONREQUESTDATA_H__

#include "qorganizer-eds-requestdata.h"

class SaveCollectionRequestData : public RequestData
{
public:
    SaveCollectionRequestData(QOrganizerEDSEngine *engine,
                              QtOrganizer::QOrganizerAbstractRequest *req);
    ~SaveCollectionRequestData();

    void finish(QtOrganizer::QOrganizerManager::Error error = QtOrganizer::QOrganizerManager::NoError,
                QtOrganizer::QOrganizerAbstractRequest::State state = QtOrganizer::QOrganizerAbstractRequest::FinishedState);
    bool prepareToCreate();
    bool prepareToUpdate();
    void setRegistry(ESourceRegistry *registry);
    ESourceRegistry *registry() const;

    GList *sourcesToCreate() const;
    void commitSourceUpdated(ESource *source, QtOrganizer::QOrganizerManager::Error error = QtOrganizer::QOrganizerManager::NoError);
    ESource *nextSourceToUpdate();

protected:
    void onSourceCreated(ESource*);

private:
    GList *m_currentSources;
    ESourceRegistry *m_registry;
    QMetaObject::Connection m_registryConnection;

    QMap<int, QtOrganizer::QOrganizerManager::Error> m_errorMap;
    QMap<int, QtOrganizer::QOrganizerCollection> m_results;
    QMap<int, ESource*> m_sources;
    QMap<int, ESource*> m_sourcesToCreate;
    QMap<int, ESource*> m_sourcesToUpdate;
    bool m_finishWasCalled;

    void parseCollections();

};

#endif
