/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FAKECAMERAFOCUSCONTROL_H
#define FAKECAMERAFOCUSCONTROL_H

#include <QCameraFocusControl>

class FakeCameraService;

class FakeCameraFocusControl : public QCameraFocusControl
{
public:
    FakeCameraFocusControl(FakeCameraService *service, QObject *parent = 0);

    QPointF customFocusPoint() const;
    QCameraFocus::FocusModes focusMode() const;
    QCameraFocus::FocusPointMode focusPointMode() const;
    QCameraFocusZoneList focusZones() const;
    bool isFocusModeSupported(QCameraFocus::FocusModes mode) const;
    bool isFocusPointModeSupported(QCameraFocus::FocusPointMode mode) const;
    void setCustomFocusPoint(const QPointF & point);
    void setFocusMode(QCameraFocus::FocusModes mode);
    void setFocusPointMode(QCameraFocus::FocusPointMode mode);

private:
    FakeCameraService *m_service;
    QCameraFocus::FocusModes m_focusMode;
    QCameraFocus::FocusPointMode m_pointMode;
    QPointF m_focusPoint;
};

#endif // FAKECAMERAFOCUSCONTROL_H
