/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <system/RegisterProtocol.h>

#include <stdio.h>

int main(int argc, char **argv) {

	RegisterProtocol protocol("qutecom2");
	if (protocol.isBinded()) {
		printf("Protocol binded: yes\n");
	} else {
		printf("Protocol binded: no\n");
	}

	if (protocol.bind("c:\\Program Files\\QuteCom\\qtqutecom.exe", "c:\\Program Files\\QuteCom\\qtqutecom.exe,0", "http://qutecom.com")) {
		printf("Protocol binded: ok\n");
	} else {
		printf("Protocol binded: failed\n");
	}

	if (protocol.unbind()) {
		printf("Protocol unbinded: ok\n");
	} else {
		printf("Protocol unbinded: failed\n");
	}

	return 0;
}
