/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "QtBrowserWidget.h"
#include "QtQuteCom.h"

#include <control/profile/CUserProfile.h>
#include <control/profile/CUserProfileHandler.h>
#include <control/CQuteCom.h>

#include <model/account/qutecom/QuteComAccount.h>
#include <model/profile/UserProfile.h>
#include <model/config/Config.h>
#include <model/config/ConfigManager.h>
#include <model/network/NetworkProxyDiscovery.h>

#include <qtutil/SafeConnect.h>
#include <util/Logger.h>
#include <util/SafeDelete.h>
#include <util/Path.h>
#include <util/WebBrowser.h>
#include <QuteComBuildId.h>

#include <QtGui/QtGui>
#include <QtWebKit/QWebView>
#include <QtCore/QtCore>

const QString ANCHOR_DIALPAD = "qutecom_dial";
const QString ANCHOR_CONTACTLIST = "qutecom_phonebook";
const QString ANCHOR_ADDCONTACT = "qutecom_addcontact";
const QString ANCHOR_SECRET_PERMANENT = "qutecom_secret_permanent";
const QString ANCHOR_SFR_FR = "qutecom_sfr_fr";
const QString ANCHOR_MON_COMPTE = "qutecom_mon_compte";
const QString ANCHOR_REPONDEUR = "qutecom_repondeur";

QtBrowserWidget::QtBrowserWidget(QtQuteCom & qtQuteCom)
	: _qtQuteCom(qtQuteCom) {

	Config & config = ConfigManager::getInstance().getCurrentConfig();
	base_path = QString::fromUtf8(config.getResourcesDir().c_str());
#if defined (OS_WINDOWS)
	base_path = base_path.replace("\\","/");
#endif

	_qtBrowser = new QWebView(_qtQuteCom.getWidget());
	_qtBrowser->setContextMenuPolicy(Qt::NoContextMenu);
	_qtBrowser ->page()->mainFrame()->setScrollBarPolicy(Qt::Horizontal,Qt::ScrollBarAlwaysOff);
	_qtBrowser ->page()->mainFrame()->setScrollBarPolicy(Qt::Vertical,Qt::ScrollBarAlwaysOff);
	
	//SAFE_CONNECT(&_qtQuteCom, SIGNAL(userProfileDeleted()), SLOT(slotUserProfileDeleted()));

	_qtBrowser ->page()->setLinkDelegationPolicy(QWebPage::DelegateAllLinks);
	connect(_qtBrowser,SIGNAL(linkClicked(const QUrl &)),this,SLOT(linkClicked_slot(const QUrl &)));
}

QtBrowserWidget::~QtBrowserWidget()
{
	OWSAFE_DELETE(_qtBrowser);
}

QWidget * QtBrowserWidget::getWidget() const 
{
	return _qtBrowser;
}

void QtBrowserWidget::slotUserProfileDeleted() 
{
	_qtBrowser->load(QUrl(base_path + "/webpages/windows/sip.html"));
}

void QtBrowserWidget::loadProgressURL() 
{
	_qtBrowser->load(QUrl(base_path  + "/webpages/windows/loading.html"));
}

void QtBrowserWidget::loadDefaultURL() 
{
	_qtBrowser->load(QUrl(base_path  + "/webpages/windows/sip.html"));
}

void QtBrowserWidget::linkClicked_slot(const QUrl & url)
{
	QString surl = url.toString();

	if(surl.contains(ANCHOR_CONTACTLIST))
	{
		//QStringList list = surl.split(ANCHOR_CONTACTLIST);
		//if(list.count() == 2)
		//{
		openqutecom_phonebook_signal();
		//}
	}
	/*else if(surl.contains(ANCHOR_HISTORY))
	{
		QStringList list = surl.split(ANCHOR_CONTACTLIST);
		if(list.count() == 2)
		{
			openqutecom_log_signal();
		}
	}
	else if(surl.contains(ANCHOR_CONFIGURATION))
	{
		QStringList list = surl.split(ANCHOR_CONTACTLIST);
		if(list.count() == 2)
		{
			openqutecom_configuration_signal();
		}
	}*/
	else if(surl.contains(ANCHOR_DIALPAD))
	{
		//QStringList list = surl.split(ANCHOR_CONTACTLIST);
		//if(list.count() == 2)
		//{
		openqutecom_dial_signal();
		//}
	}

	else if(surl.contains(ANCHOR_ADDCONTACT))
	{
		//QStringList list = surl.split(ANCHOR_CONTACTLIST);
		//if(list.count() == 2)
		//{
		openqutecom_addcontact_signal();
		//}
	}
	/*else if(surl.contains(ANCHOR_SELFCARE))
	{
		QStringList list = surl.split(ANCHOR_CONTACTLIST);
		if(list.count() == 2)
		{
			openqutecom_selfcare_signal();
		}
	}
	else if(surl.contains(ANCHOR_FORUM))
	{
		QStringList list = surl.split(ANCHOR_CONTACTLIST);
		if(list.count() == 2)
		{
			openqutecom_forum_signal();
		}
	}
	else if(surl.contains(ANCHOR_SHOWSMARTDIRECTORY))
	{
		//QStringList list = surl.split(ANCHOR_CONTACTLIST);
		//if(list.count() == 2)
		//{
		openqutecom_smartdirectory_signal();
		//}
	}*/
	else
	{
		WebBrowser::openUrl(std::string(url.toString().toUtf8()));
	}
}
