/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef QUTECOMIMWRAPPERTEST_H
#define QUTECOMIMWRAPPERTEST_H

#include <model/account/SipAccount.h>

#include <string>
#include <vector>

class QuteCom;
class Command;
class IMAccount;

class QuteComIMWrapperTest {
public:

	QuteComIMWrapperTest();

	~QuteComIMWrapperTest();

	/**
	 * Entry point of this class.
	 */
	int run();

	void quit() {
		_running = false;
	}

private:

	void loginStateChangedEventHandler(SipAccount & sender, SipAccount::LoginState state);

	void noAccountAvailableEventHandler(QuteCom & sender);

	void proxyNeedsAuthenticationEventHandler(SipAccount & sender, const std::string & proxyUrl, unsigned proxyPort);

	void wrongProxyAuthenticationEventHandler(SipAccount & sender, const std::string & proxyUrl, unsigned proxyPort,
		const std::string & proxyLogin, const std::string proxyPassword);

	void newIMAccountAddedEventHandler(QuteCom & sender, IMAccount & imAccount);

	void initWrappers();

	void initCommands(QuteCom & qutecomPhone);

	void displayMenu() const;

	bool _running;

	typedef std::vector< Command * > CommandList;
	CommandList _commands;

};

#endif /*QUTECOMIMWRAPPERTEST_H*/
