% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistic-viper.R
\name{run_viper}
\alias{run_viper}
\title{Virtual Inference of Protein-activity by Enriched Regulon analysis (VIPER)}
\usage{
run_viper(
  mat,
  network,
  .source = source,
  .target = target,
  .mor = mor,
  .likelihood = likelihood,
  verbose = FALSE,
  minsize = 5,
  pleiotropy = TRUE,
  eset.filter = FALSE,
  ...
)
}
\arguments{
\item{mat}{Matrix to evaluate (e.g. expression matrix).
Target nodes in rows and conditions in columns.
\code{rownames(mat)} must have at least one intersection with the elements
in \code{network} \code{.target} column.}

\item{network}{Tibble or dataframe with edges and it's associated metadata.}

\item{.source}{Column with source nodes.}

\item{.target}{Column with target nodes.}

\item{.mor}{Column with edge mode of regulation (i.e. mor).}

\item{.likelihood}{Deprecated argument. Now it will always be set to 1.}

\item{verbose}{Logical, whether progression messages should be printed in
the terminal.}

\item{minsize}{Integer indicating the minimum number of targets per source.}

\item{pleiotropy}{Logical, whether correction for pleiotropic regulation
should be performed.}

\item{eset.filter}{Logical, whether the dataset should be limited only to
the genes represented in the interactome.}

\item{...}{
  Arguments passed on to \code{\link[viper:viper]{viper::viper}}
  \describe{
    \item{\code{dnull}}{Numeric matrix for the null model, usually generated by \code{nullTtest}}
    \item{\code{nes}}{Logical, whether the enrichment score reported should be normalized}
    \item{\code{method}}{Character string indicating the method for computing the single samples signature, either scale, rank, mad, ttest or none}
    \item{\code{bootstraps}}{Integer indicating the number of bootstraps iterations to perform. Only the scale method is implemented with bootstraps.}
    \item{\code{adaptive.size}}{Logical, whether the weighting scores should be taken into account for computing the regulon size}
    \item{\code{pleiotropyArgs}}{list of 5 numbers for the pleotropy correction indicating: regulators p-value threshold, pleiotropic interaction p-value threshold, minimum number of targets in the overlap between pleiotropic regulators, penalty for the pleiotropic interactions and the method for computing the pleiotropy, either absolute or adaptive}
    \item{\code{cores}}{Integer indicating the number of cores to use (only 1 in Windows-based systems)}
  }}
}
\value{
A long format tibble of the enrichment scores for each source
across the samples. Resulting tibble contains the following columns:
\enumerate{
\item \code{statistic}: Indicates which method is associated with which score.
\item \code{source}: Source nodes of \code{network}.
\item \code{condition}: Condition representing each column of \code{mat}.
\item \code{score}: Regulatory activity (enrichment score).
}
}
\description{
Calculates regulatory activities using VIPER.
}
\details{
VIPER (Alvarez et al., 2016) estimates biological activities by performing a
three-tailed enrichment score calculation. For further information check the
supplementary information of the decoupler manuscript or the original
publication.

Alvarez M.J.et al. (2016) Functional characterization of somatic mutations
in cancer using network-based inference of protein activity. Nat. Genet.,
48, 838–847.
}
\examples{
inputs_dir <- system.file("testdata", "inputs", package = "decoupleR")

mat <- readRDS(file.path(inputs_dir, "mat.rds"))
net <- readRDS(file.path(inputs_dir, "net.rds"))

run_viper(mat, net, minsize=0, verbose = FALSE)
}
\seealso{
Other decoupleR statistics: 
\code{\link{decouple}()},
\code{\link{run_aucell}()},
\code{\link{run_fgsea}()},
\code{\link{run_gsva}()},
\code{\link{run_mdt}()},
\code{\link{run_mlm}()},
\code{\link{run_ora}()},
\code{\link{run_udt}()},
\code{\link{run_ulm}()},
\code{\link{run_wmean}()},
\code{\link{run_wsum}()}
}
\concept{decoupleR statistics}
