% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudobulk.R
\name{pseudobulk}
\alias{pseudobulk}
\title{Create a 'SingleCellExperiment' containing pseudo-bulk samples}
\usage{
pseudobulk(
  data,
  group_by,
  ...,
  aggregation_functions = list(counts = "rowSums2", .default = "rowMeans2"),
  col_data = NULL,
  make_colnames = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{data}{a 'SingleCellExperiment' or an object of a related class}

\item{group_by}{an unquoted expression that can refer to columns in
the 'colData()'. All observations with the same factor level are aggregated.
The argument follows the same logic as \code{dplyr::group_by()}. The argument must
wrapped using \code{vars()}.}

\item{...}{named expressions that summarize columns in 'colData()'. Each expression
must produce a value of length 1. The arguments follow the same logic
as \code{dplyr::summarize()}.}

\item{aggregation_functions}{a named list with functions that are used to
aggregate the assays in the \code{data}.}

\item{col_data}{additional data with \code{ncol(data)} rows. The \code{group_by} and named
arguments can refer to the columns of the \code{col_data} in addition to the columns in
\code{colData(data)} (assuming \code{data} is a \code{SummarizedExperiment}).}

\item{make_colnames}{a boolean that decides if the column names are the concatenated
values of \code{group_by}. Default: \code{TRUE}}

\item{verbose}{a boolean that indicates if information about the process are printed Default: \code{TRUE}.}
}
\value{
a SingleCellExperiment object
}
\description{
Create a 'SingleCellExperiment' containing pseudo-bulk samples
}
\examples{
 library(SingleCellExperiment)
 data <- data.frame(sample = sample(c("samp1", "samp2", "samp3"), size = 50, replace = TRUE),
       celltype = sample(c("T cells", "B cells", "Macrophages"), size = 50, replace = TRUE),
       size = rnorm(n = 50, mean = 40, sd = 15))
 Y <- matrix(rnbinom(n = 100 * 50, mu = 3, size = 1/3.1), nrow = 100, ncol = 50)
 sce <- SingleCellExperiment(Y, colData = data)
 aggr_sce <- pseudobulk(sce, group_by = vars(sample, celltype), size = mean(size))
 aggr_sce
 colData(aggr_sce)

}
