% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/expressedGenes.R
\name{expressedGenes}
\alias{expressedGenes}
\title{Function identifies expressed features using the methods introduced in
Core, Waterfall, Lis; Science, Dec. 2008.}
\usage{
expressedGenes(features, reads, Lambda = NULL, UnMap = NULL,
  debug = FALSE, ...)
}
\arguments{
\item{features}{A GRanges object representing a set of genomic coordinates.
The meta-plot will be centered on the start position.
There can be optional "ID" column for gene ids.}

\item{reads}{A GRanges object representing a set of mapped reads.}

\item{Lambda}{Measurement of assay noise.  Default: 0.04 reads/ kb in a
library of 10,751,533 mapped reads. (background computed in Core,
Waterfall, Lis. (2008) Science.).}

\item{UnMap}{List object representing the position of un-mappable reads.
Default: not used.}

\item{debug}{If set to true, returns the number of positions.
Default: FALSE.}

\item{...}{Extra argument passed to mclapply}
}
\value{
Returns a data.frame representing the expression p.values for
features of interest.
}
\description{
Supports parallel processing using mclapply in the 'parallel' package.
To change the number of processors use the argument 'mc.cores'.
}
\author{
Charles G. Danko
}

