% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlignmentsTrack-class.R
\docType{class}
\name{AlignmentsTrack-class}
\alias{AlignmentsTrack-class}
\alias{initialize,AlignmentsTrack-method}
\alias{ReferenceAlignmentsTrack-class}
\alias{initialize,ReferenceAlignmentsTrack-method}
\alias{AlignmentsTrack}
\alias{values,AlignmentsTrack-method}
\alias{chromosome<-,AlignmentsTrack-method}
\alias{stacks,AlignmentsTrack-method}
\alias{setStacks,AlignmentsTrack-method}
\alias{subset,AlignmentsTrack-method}
\alias{subset,ReferenceAlignmentsTrack-method}
\alias{drawAxis,AlignmentsTrack-method}
\alias{drawGD,AlignmentsTrack-method}
\alias{show,AlignmentsTrack-method}
\alias{show,ReferenceAlignmentsTrack-method}
\title{AlignmentsTrack class and methods}
\usage{
\S4method{initialize}{AlignmentsTrack}(
  .Object,
  stackRanges = GRanges(),
  stacks = numeric(),
  sequences = DNAStringSet(),
  referenceSequence = NULL,
  ...
)

\S4method{initialize}{ReferenceAlignmentsTrack}(
  .Object,
  stream,
  reference,
  mapping = list(),
  args = list(),
  defaults = list(),
  stacks = numeric(),
  stackRanges = GRanges(),
  sequences = Biostrings::DNAStringSet(),
  referenceSequence = NULL,
  ...
)

AlignmentsTrack(
  range = NULL,
  start = NULL,
  end = NULL,
  width = NULL,
  strand,
  chromosome,
  genome,
  stacking = "squish",
  id,
  cigar,
  mapq,
  flag = scanBamFlag(isUnmappedQuery = FALSE),
  isize,
  groupid,
  status,
  md,
  seqs,
  name = "AlignmentsTrack",
  isPaired = TRUE,
  importFunction,
  referenceSequence,
  ...
)

\S4method{values}{AlignmentsTrack}(x)

\S4method{chromosome}{AlignmentsTrack}(GdObject) <- value

\S4method{stacks}{AlignmentsTrack}(GdObject)

\S4method{setStacks}{AlignmentsTrack}(GdObject, ...)

\S4method{subset}{AlignmentsTrack}(x, from = NULL, to = NULL, stacks = FALSE, use.defaults = TRUE, ...)

\S4method{subset}{ReferenceAlignmentsTrack}(x, from, to, chromosome, ...)

\S4method{drawAxis}{AlignmentsTrack}(GdObject, ...)

\S4method{drawGD}{AlignmentsTrack}(GdObject, minBase, maxBase, prepare = FALSE, subset = TRUE, ...)

\S4method{show}{AlignmentsTrack}(object)

\S4method{show}{ReferenceAlignmentsTrack}(object)
}
\arguments{
\item{.Object}{.Object}

\item{stackRanges}{stackRanges}

\item{stacks}{stacks}

\item{sequences}{sequences}

\item{referenceSequence}{An optional \code{\linkS4class{SequenceTrack}}
object containing the reference sequence against which the reads have been
aligned. This is only needed when mismatch information has to be added to
the plot (i.e., the \code{showMismatchs} display parameter is \code{TRUE})
because this is normally not encoded in the \code{BAM} file. If not provided
through this argument, the \code{\link{plotTracks}} function is smart enough
to detect the presence of a \code{\linkS4class{SequenceTrack}} object in the
track list and will use that as a reference sequence.}

\item{\dots}{Additional items which will all be interpreted as further
display parameters. See \code{\link{settings}} and the "Display Parameters"
section below for details.}

\item{stream}{stream}

\item{reference}{reference}

\item{mapping}{mapping}

\item{args}{args}

\item{defaults}{defaults}

\item{range}{An optional meta argument to handle the different input types.
If the \code{range} argument is missing, all the relevant information to
create the object has to be provided as individual function arguments
(see below).

The different input options for \code{range} are:

\describe{

\item{A \code{character} string:}{ the path to a \code{BAM} file containing
the read alignments. To be precise, this will result in the instantiation of
a \code{ReferenceAlignmentsTrack} object, but for the user this
implementation detail should be of no concern.}

\item{A \code{GRanges} object:}{ the genomic ranges of the individual reads
as well as the optional additional metadata columns \code{id}, \code{cigar},
\code{mapq}, \code{flag}, \code{isize}, \code{groupid}, \code{status},
\code{md} and \code{seqs} (see description of the individual function
parameters below for details). Calling the constructor on a \code{GRanges}
object without further arguments, e.g. \code{AlignmentsTrack(range=obj)} is
equivalent to calling the coerce method \code{as(obj, "AlignmentsTrack")}.}

\item{An \code{\linkS4class{IRanges}} object:}{ almost identical to the
\code{GRanges} case, except that the chromosome and strand information as
well as all additional metadata has to be provided in the separate
\code{chromosome}, \code{strand}, \code{feature}, \code{group} or \code{id}
arguments, because it can not be directly encoded in an \code{IRanges}
object. Note that none of those inputs are mandatory, and if not provided
explicitely the more or less reasonable default values \code{chromosome=NA}
and \code{strand="*"} are used. }

\item{A \code{data.frame} object:}{ the \code{data.frame} needs to contain
at least the two mandatory columns \code{start} and \code{end} with the
range coordinates. It may also contain a \code{chromosome} and a
\code{strand} column with the chromosome and strand information for each
range. If missing it will be drawn from the separate \code{chromosome} or
\code{strand} arguments. In addition, the \code{id}, \code{cigar},
\code{mapq}, \code{flag}, \code{isize}, \code{groupid}, \code{status},
\code{md} and \code{seqs} data can be provided as additional columns. The
above comments about potential default values also apply here.}

}}

\item{start, end, width}{Integer vectors, giving the start and the end
coordinates for the individual track items, or their width. Two of the three
need to be specified, and have to be of equal length or of length one, in
which case this single value will be recycled. Otherwise, the usual R
recycling rules for vectors do not apply here.}

\item{strand}{Character vector, the strand information for the reads. It may
be provided in the form \code{+} for the Watson strand, \code{-} for the
Crick strand or \code{*} for either one of the two. Needs to be of equal
length as the provided genomic coordinates, or of length 1. Please note that
paired reads need to be on opposite strands, and erroneous entries will
result in casting of an error.}

\item{chromosome}{The chromosome on which the track's genomic ranges are
defined. A valid UCSC chromosome identifier if
\code{options(ucscChromosomeNames=TRUE)}. Please note that in this case only
syntactic checking takes place, i.e., the argument value needs to be an
integer, numeric character or a character of the form \code{chrx}, where
\code{x} may be any possible string. The user has to make sure that the
respective chromosome is indeed defined for the the track's genome. If not
provided here, the constructor will try to construct the chromosome
information based on the available inputs, and as a last resort will fall
back to the value \code{chrNA}. Please note that by definition all objects
in the \code{Gviz} package can only have a single active chromosome at a
time (although internally the information for more than one chromosome may
be present), and the user has to call the \code{chromosome<-} replacement
method in order to change to a different active chromosome.}

\item{genome}{The genome on which the track's ranges are defined. Usually
this is a valid UCSC genome identifier, however this is not being formally
checked at this point. If not provided here the constructor will try to
extract this information from the provided input, and eventually will fall
back to the default value of \code{NA}.}

\item{stacking}{The stacking type for overlapping items of the track. One in
\code{c(hide, dense, squish, pack, full)}. Currently, only squish (make best
use of the available space), dense (no stacking, collapse overlapping
ranges), and hide (do not show any track items at all) are implemented.}

\item{id}{Character vector of read identifiers. Those identifiers have to be
unique, i.e., each range representing a read needs to have a unique
\code{id}.}

\item{cigar}{A character vector of valid CIGAR strings describing details of
the alignment. Typically those include alignment gaps or insertions and
deletions, but also hard and soft clipped read regions. If missing, a fully
mapped read without gaps or indels is assumed. Needs to be of equal length
as the provided genomic coordinates, or of length 1.}

\item{mapq}{A numeric vector of read mapping qualities. Needs to be of equal
length as the provided genomic coordinates, or of length 1.}

\item{flag}{A named integer vector of length 2, as is produced by
Rsamtools::scanBamFlag(), used to filter out undesirable reads. If missing,
all mapped reads will be included.}

\item{isize}{A numeric vector of empirical insert sizes. This only applies
if the reads are paired. Needs to be of equal length as the provided genomic
coordinates, or of length 1. Currently not used.}

\item{groupid}{A factor (or vector than can be coerced into one) defining
the read pairs. Reads with the same \code{groupid} are considered to be
mates. Please note that each read group may only have one or two members.
Needs to be of equal length as the provided genomic coordinates, or of
length 1.}

\item{status}{A factor describing the mapping status of a read. Has to be
one in \code{mated}, \code{unmated} or \code{ambiguous}. Needs to be of
equal length as the provided genomic coordinates, or of length 1.}

\item{md}{A character vector describing the mapping details. This is
effectively and alternative to the CIGAR encoding and it removes the
dependency on a reference sequence to figure out read mismatches. Needs to
be of equal length as the provided genomic coordinates, or of length 1.
Currently not used.}

\item{seqs}{\code{DNAStringSet} of read sequences.}

\item{name}{Character scalar of the track's name used in the title panel
when plotting.}

\item{isPaired}{A logical scalar to determine whether the reads are paired
or not. While this may be used to render paired-end data as single-end, the
oppsite will typically not have any effect because the appropriate
\code{groupid} settings will not be present.  Thus setting \code{isPaired}
to \code{TRUE} can usually be used to autodetect the pairing state of the
input data.}

\item{importFunction}{A user-defined function to be used to import the data
from a file. This only applies when the \code{range} argument is a character
string with the path to the input data file. The function needs to accept an
argument \code{x} containing the file path and a second argument
\code{selection} with the desired plotting ranges. It has to return a proper
\code{GRanges} object with all the necessary metadata columns set. A single
default import function is already implemented in the package for \code{BAM}
files.}

\item{x}{x}

\item{GdObject}{Object of \code{GdObject-class}.}

\item{value}{value}

\item{from, to}{from,to}

\item{use.defaults}{\code{logical}}

\item{minBase, maxBase}{minBase,maxBase}

\item{prepare}{\code{logical}}

\item{subset}{\code{logical}}

\item{object}{object}
}
\value{
The return value of the constructor function is a new object of class
\code{AlignmentsTrack} or \code{ReferenceAlignmentsTrack}.
}
\description{
A class to represent short sequences that have been aligned to a reference
genome as they are typically generated in next generation sequencing
experiments.
}
\section{Functions}{
\itemize{
\item \code{initialize(AlignmentsTrack)}: Initialize.

\item \code{ReferenceAlignmentsTrack-class}: The file-based version of the \code{AlignmentsTrack-class}.

\item \code{initialize(ReferenceAlignmentsTrack)}: Initialize.

\item \code{AlignmentsTrack()}: Constructor for \code{AlignmentsTrack-class}.

\item \code{values(AlignmentsTrack)}: Return all additional annotation
information except for the genomic coordinates for the track items as
a \code{data.frame}.

\item \code{chromosome(AlignmentsTrack) <- value}: replace the value of the track's chromosome.
This has to be a valid UCSC chromosome identifier or an integer or character
scalar that can be reasonably coerced into one.

\item \code{stacks(AlignmentsTrack)}: return the stack indices for each track item.

\item \code{setStacks(AlignmentsTrack)}: recompute the stacks based on the available
space and on the object's track items and stacking settings.

\item \code{subset(AlignmentsTrack)}: Subset a \code{AlignmentsTrack} by coordinates
and sort if necessary.

\item \code{subset(ReferenceAlignmentsTrack)}: Subset a \code{ReferenceAlignmentsTrack} by coordinates
and sort if necessary.

\item \code{drawAxis(AlignmentsTrack)}: add a y-axis to the title panel of a track.

\item \code{drawGD(AlignmentsTrack)}: plot the object to a graphics device.
The return value of this method is the input object, potentially updated
during the plotting operation. Internally, there are two modes in which the
method can be called. Either in 'prepare' mode, in which case no plotting is
done but the object is preprocessed based on the available space, or in
'plotting' mode, in which case the actual graphical output is created.
Since subsetting of the object can be potentially costly, this can be
switched off in case subsetting has already been performed before or
is not necessary.

\item \code{show(AlignmentsTrack)}: Show method.

\item \code{show(ReferenceAlignmentsTrack)}: Show method.

}}
\section{Objects from the Class}{


Objects can be created using the constructor function
\code{AlignmentsTrack}.
}

\examples{
## Creating objects
afrom <- 2960000
ato <- 3160000
alTrack <- AlignmentsTrack(system.file(
    package = "Gviz", "extdata",
    "gapped.bam"
), isPaired = TRUE)
plotTracks(alTrack, from = afrom, to = ato, chromosome = "chr12")

## Omit the coverage or the pile-ups part
plotTracks(alTrack,
    from = afrom, to = ato, chromosome = "chr12",
    type = "coverage"
)
plotTracks(alTrack,
    from = afrom, to = ato, chromosome = "chr12",
    type = "pileup"
)

## Including sequence information with the constructor
if (require(BSgenome.Hsapiens.UCSC.hg19)) {
    strack <- SequenceTrack(Hsapiens, chromosome = "chr21")
    afrom <- 44945200
    ato <- 44947200
    alTrack <- AlignmentsTrack(system.file(
        package = "Gviz", "extdata",
        "snps.bam"
    ), isPaired = TRUE, referenceSequence = strack)
    plotTracks(alTrack, chromosome = "chr21", from = afrom, to = ato)

    ## Including sequence information in the track list
    alTrack <- AlignmentsTrack(system.file(
        package = "Gviz", "extdata",
        "snps.bam"
    ), isPaired = TRUE)
    plotTracks(c(alTrack, strack),
        chromosome = "chr21", from = 44946590,
        to = 44946660
    )
}
}
\seealso{
\code{\linkS4class{DisplayPars}}

\code{\linkS4class{GdObject}}

\code{\linkS4class{GRanges}}

\code{\linkS4class{HighlightTrack}}

\code{\linkS4class{ImageMap}}

\code{\linkS4class{IRanges}}

\code{\linkS4class{RangeTrack}}

\code{\linkS4class{DataTrack}}

\code{\link{collapsing}}

\code{\link{grouping}}

\code{\link{panel.grid}}

\code{\link{plotTracks}}

\code{\link{settings}}
}
\author{
Florian Hahne
}
