% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IdeogramTrack-class.R
\docType{class}
\name{IdeogramTrack-class}
\alias{IdeogramTrack-class}
\alias{IdeogramTrack}
\alias{drawGD,IdeogramTrack-method}
\alias{end,IdeogramTrack-method}
\alias{end<-,IdeogramTrack-method}
\alias{initialize,IdeogramTrack-method}
\alias{show,IdeogramTrack-method}
\alias{start,IdeogramTrack-method}
\alias{start<-,IdeogramTrack-method}
\alias{subset,IdeogramTrack-method}
\alias{width,IdeogramTrack-method}
\alias{width<-,IdeogramTrack-method}
\alias{length,IdeogramTrack-method}
\alias{[,IdeogramTrack-method}
\alias{[,IdeogramTrack,ANY,ANY-method}
\alias{[,IdeogramTrack,ANY,ANY,ANY-method}
\alias{chromosome<-,IdeogramTrack-method}
\alias{genome<-,IdeogramTrack-method}
\alias{position,IdeogramTrack-method}
\title{IdeogramTrack class and methods}
\arguments{
\item{chromosome}{The chromosome for which to create the ideogram. Has to be
a valid UCSC chromosome identifier of the form \code{chrx}, or a single
integer or numeric character unless
\code{option(ucscChromosomeNames=FALSE)}. The user has to make sure that the
respective chromosome is indeed defined for the the track's genome.}

\item{genome}{The genome on which to create the ideogram. This has to be a
valid UCSC genome identifier if the ideogram data is to be fetched from the
UCSC repository.}

\item{name}{Character scalar of the track's name used in the title panel
when plotting. Defaults to the selected chromosome.}

\item{bands}{A \code{data.frame} with the cytoband information for all
available chromosomes on the genome similar to the data that would be
fetched from UCSC. The table needs to contain the mandatory columns
\code{chrom}, \code{chromStart}, \code{chromEnd}, \code{name} and
\code{gieStain} with the chromosome name, cytoband start and end
coordinates, cytoband name and coloring information, respectively. This can
be used when no connection to the internet is available or when the cytoband
information has been cached locally to avoid the somewhat slow connection to
UCSC.}

\item{\dots}{Additional items which will all be interpreted as further
display parameters.}
}
\value{
The return value of the constructor function is a new object of class
\code{IdeogramTrack}.
}
\description{
A class to represent the schematic display of a chromosome, also known as an
ideogram. The respective information is typically directly fetched from
UCSC.
}
\details{
Ideograms are schematic depictions of chromosomes, including chromosome band
information and centromere location. The relevant data for various species
is stored in the UCSC data base. The initializer method of the class will
automatically fetch the respective data for a given genome and chromosome
from UCSC and fill the appropriate object slots. When plotting
\code{IdeogramTracks}, the current genomic location is indicated on the
chromosome by a colored box.

The \code{Gviz.ucscUrl} option controls which URL is being used to connect
to UCSC. For instance, one could switch to the European UCSC mirror by
calling \code{options(Gviz.ucscUrl="http://genome-euro.ucsc.edu/cgi-bin/"}.
}
\note{
When fetching ideogram data from UCSC the results are cached for faster
acces. See \code{\link{clearSessionCache}} on details to delete these cached
items.
}
\section{Objects from the Class}{


Objects can be created using the constructor function \code{IdeogramTrack}.
}

\examples{
\dontshow{
## Load some sample data
data(idTrack)
}

## Construct the object
\dontrun{
idTrack <- IdeogramTrack(chromosome = 7, genome = "mm9")
}

\dontshow{
## For some annoying reason the postscript device does not know about
## the sans font
if (!interactive()) {
    font <- ps.options()$family
    displayPars(idTrack) <- list(fontfamily = font, fontfamily.title = font)
}
}

## Plotting
plotTracks(idTrack, from = 5000000, to = 9000000)

## Track names
names(idTrack)
names(idTrack) <- "foo"
plotTracks(idTrack, from = 5000000, to = 9000000)


## Accessors
chromosome(idTrack)
\dontrun{
chromosome(idTrack) <- "chrX"
}

genome(idTrack)
\dontrun{
genome(id) <- "hg19"
}

range(idTrack)
ranges(idTrack)

## Annotation
values(idTrack)

## coercion
as(idTrack, "data.frame")
}
\seealso{
\code{\linkS4class{DisplayPars}}

\code{\linkS4class{GdObject}}

\code{\linkS4class{GRanges}}

\code{\linkS4class{HighlightTrack}}

\code{\linkS4class{ImageMap}}

\code{\linkS4class{IRanges}}

\code{\linkS4class{RangeTrack}}

\code{\linkS4class{DataTrack}}

\code{\link{collapsing}}

\code{\link{grouping}}

\code{\link{panel.grid}}

\code{\link{plotTracks}}

\code{\link{settings}}
}
\author{
Florian Hahne
}
