% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchMetadataSchema.R
\name{fetchMetadataSchema}
\alias{fetchMetadataSchema}
\title{Fetch a metadata schema}
\usage{
fetchMetadataSchema(
  name = "bioconductor/v1.json",
  cache = cacheDirectory(),
  overwrite = FALSE
)
}
\arguments{
\item{name}{String containing the name of the schema.
This can be the name of any JSON schema file published at \url{https://github.com/ArtifactDB/bioconductor-metadata-index}.}

\item{cache}{String containing the cache directory.
If \code{NULL}, no caching is performed.}

\item{overwrite}{Logical scalar indicating whether to overwrite an existing file in \code{cache}, if one is present.}
}
\value{
String containing a path to the downloaded schema.
}
\description{
Fetch a JSON schema file for metadata to be inserted into a SQLite database
(see \url{https://github.com/ArtifactDB/bioconductor-metadata-index}).
Each SQLite database is created from metadata files uploaded to the gypsum backend,
so clients uploading objects to be incorporated into the database should validate their metadata against the corresponding JSON schema.
}
\examples{
fetchMetadataSchema()
}
\seealso{
\code{\link{validateMetadata}}, to validate metadata against a chosen schema.

\code{\link{fetchMetadataDatabase}}, to obtain the SQLite database of metadata.
}
\author{
Aaron Lun
}
