% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatObjectMetadata.R
\name{formatObjectMetadata}
\alias{formatObjectMetadata}
\title{Format object-related metadata}
\usage{
formatObjectMetadata(x)
}
\arguments{
\item{x}{An R object, typically an instance of a Bioconductor class.}
}
\value{
List containing the object-related metadata, typically stored in the \code{applications.takane} field of the metadata.
}
\description{
Create object-related metadata to validate against the default schema from \code{\link{fetchMetadataSchema}}.
This is intended for downstream package developers who are auto-generating metadata documents to be validated by \code{\link{validateMetadata}}.
}
\examples{
df <- S4Vectors::DataFrame(alpha=LETTERS, numeric=runif(26))
formatObjectMetadata(df)

}
\author{
Aaron Lun
}
