% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBubble.R
\name{plotBubble}
\alias{plotBubble}
\title{Basic plot of binned vectors.}
\usage{
plotBubble(yvector, xvector, sigvector = NULL, nbreaks = 10,
  ybreak = quantile(yvector, p = seq(0, 1, length.out = nbreaks)),
  xbreak = quantile(xvector, p = seq(0, 1, length.out = nbreaks)),
  scale = 1, local = FALSE, ...)
}
\arguments{
\item{yvector}{A vector of values represented along y-axis.}

\item{xvector}{A vector of values represented along x-axis.}

\item{sigvector}{A vector of the names of significant features (names should match x/yvector).}

\item{nbreaks}{Number of bins to break yvector and xvector into.}

\item{ybreak}{The values to break the yvector at.}

\item{xbreak}{The values to break the xvector at.}

\item{scale}{Scaling of circle bin sizes.}

\item{local}{Boolean to shade by signficant bin numbers (TRUE) or overall proportion (FALSE).}

\item{...}{Additional plot arguments.}
}
\value{
A matrix of features along rows, and the group membership along columns.
}
\description{
This function plots takes two vectors, calculates the contingency table and 
plots circles sized by the contingency table value. Optional significance vectors
of the values significant will shade the circles by proportion of significance.
}
\examples{

data(mouseData)
mouseData = mouseData[which(rowSums(mouseData)>139),]
sparsity = rowMeans(MRcounts(mouseData)==0)
lor = log(fitPA(mouseData,cl=pData(mouseData)[,3])$oddsRatio)
plotBubble(lor,sparsity,main="lor ~ sparsity")
# Example 2
x = runif(100000)
y = runif(100000)
plotBubble(y,x)

}
\seealso{
\code{\link{plotMRheatmap}}
}
