% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handling.R
\name{repool}
\alias{repool}
\title{Pool several genotypes into a single dataset}
\usage{
repool(..., list = FALSE)
}
\arguments{
\item{...}{a list of \linkS4class{genind} objects, or a series of \linkS4class{genind} objects separated by commas}

\item{list}{a logical indicating whether a list of objects with matched alleles shall be returned (TRUE), or a single \linkS4class{genind} object (FALSE, default).}
}
\description{
The function \code{repool} allows to merge genotypes from different
 \linkS4class{genind} objects into a single 'pool' (i.e. a new \linkS4class{genind}).
 The markers have to be the same for all objects to be merged, but
 there is no constraint on alleles.\cr
}
\details{
This function can be useful, for instance, when hybrids are created
 using \code{\link{hybridize}}, to merge hybrids with their parent
 population for further analyses. Note that \code{repool} can also
 reverse the action of \code{\link{seppop}}.
}
\examples{
\dontrun{
## use the cattle breeds dataset
data(microbov)
temp <- seppop(microbov)
names(temp)
## hybridize salers and zebu -- nasty cattle
zebler <- hybridize(temp$Salers, temp$Zebu, n=40)
zebler
## now merge zebler with other cattle breeds
nastyCattle <- repool(microbov, zebler)
nastyCattle
}

}
\seealso{
\code{\link{seploc}}, \code{\link{seppop}}
}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}
}
