% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_week_start.R
\name{change_week_start}
\alias{change_week_start}
\title{Change the week start of an aweek object}
\usage{
change_week_start(x, week_start = NULL, ...)
}
\arguments{
\item{x}{a \link{Date}, \link{POSIXt}, \link{character}, or any data that can be easily
converted to a date with \code{\link[=as.POSIXlt]{as.POSIXlt()}}.}

\item{week_start}{a number indicating the start of the week based on the ISO
8601 standard from 1 to 7 where 1 = Monday OR an abbreviation of the
weekdate in an English or current locale. \emph{Note: using a non-English locale
may render your code non-portable.} Unlike \code{\link[=date2week]{date2week()}}, this defaults to
NULL, which will throw an error unless you supply a value.}

\item{...}{arguments passed to \code{\link[=as.POSIXlt]{as.POSIXlt()}}, unused in all other cases.}
}
\description{
This will change the week_start attribute of an aweek object and adjust the
observations accordingly.
}
\examples{
# New Year's 2019 is the third day of the week starting on a Sunday
s <- date2week(as.Date("2019-01-01"), week_start = "Sunday")
s 

# It's the second day of the week starting on a Monday
m <- change_week_start(s, "Monday") 
m

# When you compare the underlying dates, they are exactly the same
identical(as.Date(s), as.Date(m))

# Since this will pass arguments to `date2week()`, you can modify other
# aspects of the aweek object this way, but this is not advised.

change_week_start(s, "Monday", floor_day = TRUE)
}
\seealso{
\code{\link[=get_week_start]{get_week_start()}} for accessing the global and local \code{week_start}
attribute, \code{\link[=as.aweek]{as.aweek()}}, which wraps this function.
}
